/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.tools.ant.DirectoryScanner;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;

public abstract class AbstractPushStrategy {
    private PushOptions opts;
    private StringSet extensions;
    private String fileExtension;

    public abstract Set<String> findDocNames(File var1, List<String> var2, List<String> var3, boolean var4) throws IOException;

    public abstract Resource loadSrcDoc(File var1, String var2) throws IOException;

    public abstract void visitTranslationResources(String var1, Resource var2, PushCommand.TranslationResourcesVisitor var3) throws IOException;

    public AbstractPushStrategy(StringSet extensions, String fileExtension) {
        this.extensions = extensions;
        this.fileExtension = fileExtension;
    }

    public String[] getSrcFiles(File srcDir, List<String> includes, List<String> excludes, boolean excludeLocalFileName, boolean includeDefaultExclude) {
        if (includes.isEmpty()) {
            includes.add("**/*" + this.fileExtension);
        }
        if (excludeLocalFileName) {
            this.excludeLocaleFileName(excludes);
        }
        DirectoryScanner dirScanner = new DirectoryScanner();
        if (includeDefaultExclude) {
            dirScanner.addDefaultExcludes();
        }
        dirScanner.setBasedir(srcDir);
        dirScanner.setCaseSensitive(false);
        dirScanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        dirScanner.setIncludes(includes.toArray(new String[includes.size()]));
        dirScanner.scan();
        String[] includedFiles = dirScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = includedFiles[i].replace(File.separator, "/");
        }
        return includedFiles;
    }

    private void excludeLocaleFileName(List<String> excludes) {
        for (LocaleMapping locMap : this.opts.getLocaleMapList()) {
            String loc = locMap.getJavaLocale().toLowerCase();
            excludes.add("**/*_" + loc + this.fileExtension);
        }
    }

    protected String docNameToFilename(String docName) {
        return docName + this.fileExtension;
    }

    protected String docNameToFilename(String docName, LocaleMapping locale) {
        return docName + "_" + locale.getJavaLocale() + this.fileExtension;
    }

    public void setPushOptions(PushOptions opts) {
        this.opts = opts;
    }

    public StringSet getExtensions() {
        return this.extensions;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public PushOptions getOpts() {
        return this.opts;
    }

    public void init() {
    }
}

