/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.DummyResponse;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PublicanPushCommand;
import org.zanata.client.commands.PublicanPushOptions;
import org.zanata.client.commands.PublicanPushOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

@Test(groups={"unit-tests"})
public class PublicanPushCommandTest {
    IMocksControl control = EasyMock.createControl();
    ISourceDocResource mockSourceDocResource = this.createMock("mockSourceDocResource", ISourceDocResource.class);
    ITranslatedDocResource mockTranslationResources = this.createMock("mockTranslationResources", ITranslatedDocResource.class);

    @Test
    public void publicanPushPot() throws Exception {
        this.publicanPush(false, false);
    }

    @Test
    public void publicanPushPotAndPo() throws Exception {
        this.publicanPush(true, false);
    }

    @Test
    public void publicanPushPotAndPoWithLocaleMapping() throws Exception {
        this.publicanPush(true, true);
    }

    @BeforeMethod
    void beforeMethod() {
        this.control.reset();
    }

    <T> T createMock(String name, Class<T> toMock) {
        Object mock = this.control.createMock(name, toMock);
        return (T)mock;
    }

    private void publicanPush(boolean importPo, boolean mapLocale) throws Exception {
        PublicanPushOptionsImpl opts = new PublicanPushOptionsImpl();
        opts.setInteractiveMode(false);
        String projectSlug = "project";
        opts.setProj(projectSlug);
        String versionSlug = "1.0";
        opts.setProjectVersion(versionSlug);
        opts.setSrcDir(new File("src/test/resources/test1"));
        opts.setImportPo(importPo);
        OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
        if (mapLocale) {
            LocaleList locales = new LocaleList();
            locales.add(new LocaleMapping("ja", "ja-JP"));
            opts.setLocaleMapList(locales);
        }
        ArrayList<ResourceMeta> resourceMetaList = new ArrayList<ResourceMeta>();
        resourceMetaList.add(new ResourceMeta("obsolete"));
        resourceMetaList.add(new ResourceMeta("RPM"));
        EasyMock.expect((Object)this.mockSourceDocResource.get(null)).andReturn(new DummyResponse(Response.Status.OK, resourceMetaList));
        DummyResponse<Object> okResponse = new DummyResponse<Object>(Response.Status.OK, null);
        EasyMock.expect((Object)this.mockSourceDocResource.deleteResource("obsolete")).andReturn(okResponse);
        StringSet extensionSet = new StringSet("gettext;comment");
        EasyMock.expect((Object)this.mockSourceDocResource.putResource((String)EasyMock.eq((Object)"RPM"), (Resource)EasyMock.notNull(), (Set)EasyMock.eq((Object)extensionSet), EasyMock.eq((boolean)true))).andReturn(okResponse);
        EasyMock.expect((Object)this.mockSourceDocResource.putResource((String)EasyMock.eq((Object)"sub,RPM"), (Resource)EasyMock.notNull(), (Set)EasyMock.eq((Object)extensionSet), EasyMock.eq((boolean)true))).andReturn(okResponse);
        if (importPo) {
            LocaleId expectedLocale = mapLocale ? new LocaleId("ja") : new LocaleId("ja-JP");
            EasyMock.expect((Object)this.mockTranslationResources.putTranslations((String)EasyMock.eq((Object)"RPM"), (LocaleId)EasyMock.eq((Object)expectedLocale), (TranslationsResource)EasyMock.notNull(), (Set)EasyMock.eq((Object)extensionSet), (String)EasyMock.eq((Object)"auto"))).andReturn(okResponse);
        }
        ZanataProxyFactory mockRequestFactory = (ZanataProxyFactory)EasyMock.createNiceMock(ZanataProxyFactory.class);
        this.control.replay();
        PublicanPushCommand cmd = new PublicanPushCommand((PublicanPushOptions)opts, mockRequestFactory, this.mockSourceDocResource, this.mockTranslationResources, new URI("http://example.com/"));
        cmd.run();
        this.control.verify();
    }
}

