/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.DummyResponse;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;

@Test(groups={"unit-tests"})
public class PushCommandTest {
    IMocksControl control = EasyMock.createControl();
    ISourceDocResource mockSourceDocResource = this.createMock("mockSourceDocResource", ISourceDocResource.class);
    ITranslatedDocResource mockTranslationResources = this.createMock("mockTranslationResources", ITranslatedDocResource.class);

    @Test
    public void pushSrc() throws Exception {
        this.push(false, false);
    }

    @Test
    public void pushSrcAndTarget() throws Exception {
        this.push(true, false);
    }

    @Test
    public void pushSrcAndTargetWithLocaleMapping() throws Exception {
        this.push(true, true);
    }

    @Test
    public void testSplitTranslationResource() throws Exception {
        int batchSize = 100;
        int listSize = 500;
        this.checkSplitResult(listSize, batchSize);
        batchSize = 50;
        listSize = 500;
        this.checkSplitResult(listSize, batchSize);
    }

    @Test
    public void testSplitTranslationResourceWithMod() throws Exception {
        int batchSize = 100;
        int listSize = 505;
        this.checkSplitResult(listSize, batchSize);
        batchSize = 100;
        listSize = 510;
        this.checkSplitResult(listSize, batchSize);
    }

    private void checkSplitResult(int listSize, int batchSize) throws Exception {
        int expectLastTftSize;
        PushCommand cmd = this.generatePushCommand(true, true);
        TranslationsResource transRes = new TranslationsResource();
        for (int i = 0; i < listSize; ++i) {
            transRes.getTextFlowTargets().add(new TextFlowTarget(String.valueOf(i)));
        }
        List list = cmd.splitIntoBatch(transRes, batchSize);
        int expectListSize = listSize / batchSize;
        if (listSize % batchSize != 0) {
            ++expectListSize;
        }
        if ((expectLastTftSize = listSize % batchSize) == 0) {
            expectLastTftSize = batchSize;
        }
        Assert.assertEquals((int)list.size(), (int)expectListSize);
        Assert.assertEquals((int)((TranslationsResource)list.get(0)).getTextFlowTargets().size(), (int)batchSize);
        Assert.assertEquals((int)((TranslationsResource)list.get(list.size() - 1)).getTextFlowTargets().size(), (int)expectLastTftSize);
    }

    private PushCommand generatePushCommand(boolean pushTrans, boolean mapLocale) throws Exception {
        PushOptionsImpl opts = new PushOptionsImpl();
        opts.setInteractiveMode(false);
        String projectSlug = "project";
        opts.setProj(projectSlug);
        String versionSlug = "1.0";
        opts.setProjectVersion(versionSlug);
        opts.setSrcDir(new File("src/test/resources/test1/pot"));
        opts.setPushTrans(pushTrans);
        opts.transDir = new File("src/test/resources/test1");
        opts.setProjectType("podir");
        opts.copyTrans = true;
        opts.includes = new ArrayList<String>();
        opts.excludes = new ArrayList<String>();
        opts.sourceLang = "en-US";
        opts.mergeType = "auto";
        opts.batchSize = 100;
        LocaleList locales = new LocaleList();
        if (mapLocale) {
            locales.add(new LocaleMapping("ja", "ja-JP"));
        } else {
            locales.add(new LocaleMapping("ja-JP"));
        }
        opts.setLocaleMapList(locales);
        OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
        ZanataProxyFactory mockRequestFactory = (ZanataProxyFactory)EasyMock.createNiceMock(ZanataProxyFactory.class);
        return new PushCommand((PushOptions)opts, mockRequestFactory, this.mockSourceDocResource, this.mockTranslationResources, new URI("http://example.com/"));
    }

    @BeforeMethod
    void beforeMethod() {
        this.control.reset();
    }

    <T> T createMock(String name, Class<T> toMock) {
        Object mock = this.control.createMock(name, toMock);
        return (T)mock;
    }

    private void push(boolean pushTrans, boolean mapLocale) throws Exception {
        ArrayList<ResourceMeta> resourceMetaList = new ArrayList<ResourceMeta>();
        resourceMetaList.add(new ResourceMeta("obsolete"));
        resourceMetaList.add(new ResourceMeta("RPM"));
        EasyMock.expect((Object)this.mockSourceDocResource.get(null)).andReturn(new DummyResponse(Response.Status.OK, resourceMetaList));
        DummyResponse<Object> okResponse = new DummyResponse<Object>(Response.Status.OK, null);
        EasyMock.expect((Object)this.mockSourceDocResource.deleteResource("obsolete")).andReturn(okResponse);
        StringSet extensionSet = new StringSet("gettext;comment");
        EasyMock.expect((Object)this.mockSourceDocResource.putResource((String)EasyMock.eq((Object)"RPM"), (Resource)EasyMock.notNull(), (Set)EasyMock.eq((Object)extensionSet), EasyMock.eq((boolean)true))).andReturn(okResponse);
        EasyMock.expect((Object)this.mockSourceDocResource.putResource((String)EasyMock.eq((Object)"sub,RPM"), (Resource)EasyMock.notNull(), (Set)EasyMock.eq((Object)extensionSet), EasyMock.eq((boolean)true))).andReturn(okResponse);
        if (pushTrans) {
            LocaleId expectedLocale = mapLocale ? new LocaleId("ja") : new LocaleId("ja-JP");
            EasyMock.expect((Object)this.mockTranslationResources.putTranslations((String)EasyMock.eq((Object)"RPM"), (LocaleId)EasyMock.eq((Object)expectedLocale), (TranslationsResource)EasyMock.notNull(), (Set)EasyMock.eq((Object)extensionSet), (String)EasyMock.eq((Object)"auto"))).andReturn(okResponse);
        }
        this.control.replay();
        PushCommand cmd = this.generatePushCommand(pushTrans, mapLocale);
        cmd.run();
        this.control.verify();
    }
}

