/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.fedorahosted.openprops.Properties;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.zanata.client.commands.push.PropertiesStrategy;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;

@Test
public class PushPropertiesStrategyTest {
    IMocksControl control = EasyMock.createControl();
    File outDir = new File("target/test-output/readprops/");
    Properties props = new Properties();
    PushOptions opts;

    public PushPropertiesStrategyTest() {
        this.outDir.mkdirs();
        this.props.setProperty("key", "value");
        this.props.setProperty("unicode", "\u30ec\u30b9");
        this.opts = (PushOptions)this.control.createMock(PushOptions.class);
        EasyMock.expect((Object)this.opts.getSourceLang()).andReturn((Object)"en").anyTimes();
        this.control.replay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void utf8() throws Exception {
        File f = new File(this.outDir, "utf8.properties");
        FileOutputStream fos = new FileOutputStream(f);
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            this.props.store((Writer)w, null);
        }
        finally {
            fos.close();
        }
        PropertiesStrategy strat = new PropertiesStrategy("UTF-8");
        strat.setPushOptions(this.opts);
        strat.init();
        Resource doc = strat.loadSrcDoc(this.outDir, "utf8");
        this.checkResults(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void latin1() throws Exception {
        File f = new File(this.outDir, "latin1.properties");
        FileOutputStream fos = new FileOutputStream(f);
        try {
            this.props.store((OutputStream)fos, null);
        }
        finally {
            fos.close();
        }
        PropertiesStrategy strat = new PropertiesStrategy();
        strat.setPushOptions(this.opts);
        strat.init();
        Resource doc = strat.loadSrcDoc(this.outDir, "latin1");
        this.checkResults(doc);
    }

    private void checkResults(Resource doc) {
        Assert.assertEquals((String)((TextFlow)doc.getTextFlows().get(0)).getId(), (String)"key");
        Assert.assertEquals((Collection)((TextFlow)doc.getTextFlows().get(0)).getContents(), Arrays.asList("value"));
        Assert.assertEquals((String)((TextFlow)doc.getTextFlows().get(1)).getId(), (String)"unicode");
        Assert.assertEquals((Collection)((TextFlow)doc.getTextFlows().get(1)).getContents(), Arrays.asList("\u30ec\u30b9"));
    }
}

