/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.AppAbortStrategy;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.SystemExitStrategy;
import org.zanata.client.commands.ZanataCommand;

public class ArgsUtil {
    private static final Logger log = LoggerFactory.getLogger(ArgsUtil.class);
    private final AppAbortStrategy abortStrategy;
    private final PrintStream out;
    private final PrintStream err;

    public ArgsUtil(AppAbortStrategy strategy, PrintStream out, PrintStream err) {
        this.abortStrategy = strategy;
        this.out = out;
        this.err = err;
    }

    public static void processArgs(String[] args, BasicOptions opts) {
        new ArgsUtil(new SystemExitStrategy(), System.out, System.err).process(args, opts);
    }

    public void process(String[] args, BasicOptions opts) {
        CmdLineParser parser;
        block9: {
            log.debug("process(args: {}, opts: {})", (Object)args, (Object)opts);
            parser = new CmdLineParser((Object)opts);
            try {
                parser.setUsageWidth(Integer.parseInt(System.getenv("COLUMNS")));
            }
            catch (Exception e) {
                parser.setUsageWidth(120);
            }
            try {
                parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                if (opts.getHelp() || args.length == 0) break block9;
                this.err.println(e.getMessage());
                ArgsUtil.printHelp(opts, this.err);
                parser.printUsage((OutputStream)this.err);
                this.abortStrategy.abort(e);
            }
        }
        if (opts.getHelp() || args.length == 0) {
            ArgsUtil.printHelp(opts, this.out);
            parser.printUsage((OutputStream)this.out);
            return;
        }
        ArgsUtil.setLogLevels(opts);
        try {
            if (opts instanceof ConfigurableOptions) {
                OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
            }
            ZanataCommand cmd = opts.initCommand();
            ArgsUtil.setLogLevels(opts);
            if (opts.getErrors()) {
                log.info("Error stacktraces are turned on.");
            }
            cmd.run();
        }
        catch (Exception e) {
            ArgsUtil.handleException(e, opts.getErrors(), this.abortStrategy);
        }
    }

    private static void setLogLevels(BasicOptions opts) {
        if (opts.getDebug()) {
            ArgsUtil.enableDebugLogging();
        } else if (opts.getQuiet()) {
            ArgsUtil.enableQuietLogging();
        }
    }

    private static void enableDebugLogging() {
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        root.setLevel(Level.DEBUG);
    }

    private static void enableQuietLogging() {
        org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
        root.setLevel(Level.ERROR);
    }

    private static void printHelp(BasicOptions cmd, PrintStream output) {
        output.println("Usage: " + cmd.getCommandName() + " [options]");
        output.println(cmd.getCommandDescription());
        output.println();
    }

    public static void handleException(Exception e, boolean outputErrors, AppAbortStrategy abortStrategy) {
        if (outputErrors) {
            log.error("Execution failed: ", (Throwable)e);
        } else {
            log.error("Execution failed: " + e.getMessage());
            log.error("Use -e/--errors for full stack trace (or when reporting bugs)");
        }
        abortStrategy.abort(e);
    }
}

