/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.PutUserOptions;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.IAccountResource;
import org.zanata.rest.dto.Account;

public class PutUserCommand
extends ConfigurableCommand<PutUserOptions> {
    private static final Logger log = LoggerFactory.getLogger(PutUserCommand.class);

    public PutUserCommand(PutUserOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws Exception {
        Account account = new Account();
        account.setEmail(((PutUserOptions)this.getOpts()).getUserEmail());
        account.setName(((PutUserOptions)this.getOpts()).getUserName());
        account.setUsername(((PutUserOptions)this.getOpts()).getUserUsername());
        account.setPasswordHash(((PutUserOptions)this.getOpts()).getUserPasswordHash());
        account.setApiKey(((PutUserOptions)this.getOpts()).getUserKey());
        account.setEnabled(!((PutUserOptions)this.getOpts()).isUserDisabled());
        account.setRoles(new HashSet<String>(Arrays.asList(((PutUserOptions)this.getOpts()).getUserRoles().split(","))));
        account.setTribes(new HashSet<String>(Arrays.asList(((PutUserOptions)this.getOpts()).getUserLangs().split(","))));
        log.debug("{}", (Object)account);
        IAccountResource iterResource = this.getRequestFactory().getAccount(((PutUserOptions)this.getOpts()).getUserUsername());
        URI uri = this.getRequestFactory().getAccountURI(((PutUserOptions)this.getOpts()).getUserUsername());
        ClientResponse response = iterResource.put(account);
        ClientUtility.checkResult((ClientResponse)response, (URI)uri);
    }
}

