/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.push;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.zanata.client.commands.glossary.push.AbstractGlossaryPushReader;
import org.zanata.common.LocaleId;
import org.zanata.rest.dto.Glossary;
import org.zanata.rest.dto.GlossaryEntry;
import org.zanata.rest.dto.GlossaryTerm;

public class GlossaryCSVReader
extends AbstractGlossaryPushReader {
    @Override
    public List<Glossary> extractGlossary(File glossaryFile) throws IOException, RuntimeException {
        int entryCount = 0;
        ArrayList<Glossary> glossaries = new ArrayList<Glossary>();
        CSVReader reader = new CSVReader((Reader)new FileReader(glossaryFile));
        List entries = reader.readAll();
        this.validateCVSEntries(entries);
        Map<Integer, String> descriptionMap = this.setupDescMap(entries);
        Map<Integer, LocaleId> localeColMap = this.setupLocalesMap(entries, descriptionMap);
        LocaleId srcLocale = localeColMap.get(0);
        Glossary glossary = new Glossary();
        for (int i = 1; i < entries.size(); ++i) {
            String[] row = (String[])entries.get(i);
            GlossaryEntry entry = new GlossaryEntry();
            entry.setSrcLang(srcLocale);
            for (int x = 0; x < row.length && localeColMap.containsKey(x); ++x) {
                GlossaryTerm term = new GlossaryTerm();
                term.setLocale(localeColMap.get(x));
                term.setContent(row[x]);
                if (x == 0) {
                    for (int descRow : descriptionMap.keySet()) {
                        term.getComments().add(row[descRow]);
                    }
                }
                entry.getGlossaryTerms().add(term);
            }
            glossary.getGlossaryEntries().add(entry);
            if (++entryCount != this.getOpts().getBatchSize() && i != entries.size() - 1) continue;
            glossaries.add(glossary);
            entryCount = 0;
            glossary = new Glossary();
        }
        return glossaries;
    }

    private void validateCVSEntries(List<String[]> entries) {
        if (entries.isEmpty() || entries == null) {
            throw new RuntimeException("Invalid CSV file - empty file");
        }
        if (entries.size() < 2) {
            throw new RuntimeException("Invalid CSV file - no entries found");
        }
        for (String[] row : entries) {
            if (entries.get(0).length == row.length) continue;
            throw new RuntimeException("Invalid CSV file - inconsistency of columns with header");
        }
    }

    private Map<Integer, LocaleId> setupLocalesMap(List<String[]> entries, Map<Integer, String> descriptionMap) {
        HashMap<Integer, LocaleId> localeColMap = new HashMap<Integer, LocaleId>();
        String[] headerRow = entries.get(0);
        for (int row = 0; row < headerRow.length && !descriptionMap.containsKey(row); ++row) {
            LocaleId locale = this.getLocaleFromMap(headerRow[row]);
            localeColMap.put(row, locale);
        }
        return localeColMap;
    }

    private Map<Integer, String> setupDescMap(List<String[]> entries) {
        HashMap<Integer, String> descMap = new HashMap<Integer, String>();
        String[] headerRow = entries.get(0);
        for (int row = 0; row < headerRow.length; ++row) {
            for (String optsHeader : this.getOpts().getCommentCols()) {
                if (!optsHeader.equals(headerRow[row])) continue;
                descMap.put(row, headerRow[row]);
            }
        }
        ValueComparator bvc = new ValueComparator(descMap);
        TreeMap<Integer, String> sorted_map = new TreeMap<Integer, String>(bvc);
        sorted_map.putAll(descMap);
        return sorted_map;
    }

    static class ValueComparator
    implements Comparator<Integer> {
        Map<Integer, String> base;

        public ValueComparator(Map<Integer, String> base) {
            this.base = base;
        }

        @Override
        public int compare(Integer a, Integer b) {
            String strA = this.base.get(a);
            String strB = this.base.get(b);
            if (strA == null || strB == null) {
                return strA == null ? -1 : 1;
            }
            return strA.compareTo(strB);
        }
    }
}

