/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullStrategy;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.PathUtil;

public class XmlStrategy
implements PullStrategy {
    private JAXBContext jaxbContext;
    private Marshaller marshaller;
    private PullOptions pullOptions;
    StringSet extensions = new StringSet("comment;gettext");

    public XmlStrategy() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Resource.class, TranslationsResource.class});
            this.marshaller = this.jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setPullOptions(PullOptions opts) {
        this.pullOptions = opts;
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return false;
    }

    private String docNameToFilename(String docName) {
        return docName + ".xml";
    }

    private String docNameToFilename(String docName, LocaleMapping locale) {
        return docName + "_" + locale.getJavaLocale() + ".xml";
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        try {
            String filename = this.docNameToFilename(doc.getName());
            File srcFile = new File(this.pullOptions.getSrcDir(), filename);
            PathUtil.makeParents((File)srcFile);
            this.marshaller.marshal((Object)doc, srcFile);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeTransFile(Resource doc, String docName, LocaleMapping locale, TranslationsResource targetDoc) throws IOException {
        try {
            String filename = this.docNameToFilename(docName, locale);
            File transFile = new File(this.pullOptions.getTransDir(), filename);
            PathUtil.makeParents((File)transFile);
            this.marshaller.marshal((Object)targetDoc, transFile);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }
}

