/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.zanata.adapter.po.PoReader2;
import org.zanata.client.commands.gettext.PublicanUtil;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushPullType;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

class GettextDirStrategy
extends AbstractPushStrategy {
    private static final Logger log = LoggerFactory.getLogger(GettextDirStrategy.class);
    PoReader2 poReader = new PoReader2();
    List<LocaleMapping> locales;

    public GettextDirStrategy() {
        super(new StringSet("comment;gettext"), ".pot");
    }

    @Override
    public Set<String> findDocNames(File srcDir, List<String> includes, List<String> excludes, boolean includeDefaultExclude) throws IOException {
        String[] srcFiles;
        HashSet<String> localDocNames = new HashSet<String>();
        for (String potName : srcFiles = this.getSrcFiles(srcDir, includes, excludes, false, includeDefaultExclude)) {
            String docName = FilenameUtils.removeExtension((String)potName);
            localDocNames.add(docName);
        }
        return localDocNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws IOException {
        File srcFile = new File(sourceDir, docName + this.getFileExtension());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile));
        try {
            InputSource potInputSource = new InputSource(bis);
            potInputSource.setEncoding("utf8");
            Resource resource = this.poReader.extractTemplate(potInputSource, new LocaleId(this.getOpts().getSourceLang()), docName);
            return resource;
        }
        finally {
            bis.close();
        }
    }

    private List<LocaleMapping> findLocales() {
        if (this.locales != null) {
            return this.locales;
        }
        if (this.getOpts().getPushType() == PushPullType.Both || this.getOpts().getPushType() == PushPullType.Trans) {
            if (this.getOpts().getLocaleMapList() != null) {
                this.locales = PublicanUtil.findLocales(this.getOpts().getTransDir(), this.getOpts().getLocaleMapList());
                if (this.locales.size() == 0) {
                    log.warn("'pushType' is set to '" + (Object)((Object)this.getOpts().getPushType()) + "', but none of the configured locale " + "directories was found (check zanata.xml)");
                }
            } else {
                this.locales = PublicanUtil.findLocales(this.getOpts().getTransDir());
                if (this.locales.size() == 0) {
                    log.warn("'pushType' is set to '\" + getOpts().getPushType() + \"', but no locale directories were found");
                } else {
                    log.info("'pushType' is set to '\" + getOpts().getPushType() + \"', but no locales specified in configuration: importing " + this.locales.size() + " directories");
                }
            }
        }
        return this.locales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitTranslationResources(String docName, Resource srcDoc, PushCommand.TranslationResourcesVisitor callback) throws IOException {
        for (LocaleMapping locale : this.findLocales()) {
            File localeDir = new File(this.getOpts().getTransDir(), locale.getLocalLocale());
            File transFile = new File(localeDir, docName + ".po");
            if (!transFile.canRead()) continue;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(transFile));
            try {
                InputSource inputSource = new InputSource(bis);
                inputSource.setEncoding("utf8");
                TranslationsResource targetDoc = this.poReader.extractTarget(inputSource);
                callback.visit(locale, targetDoc);
            }
            finally {
                bis.close();
            }
        }
    }
}

