/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FilenameUtils;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class XmlStrategy
extends AbstractPushStrategy {
    private JAXBContext jaxbContext;
    private Unmarshaller unmarshaller;

    public XmlStrategy() {
        super(new StringSet("comment;gettext"), ".xml");
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Resource.class, TranslationsResource.class});
            this.unmarshaller = this.jaxbContext.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Set<String> findDocNames(File srcDir, List<String> includes, List<String> excludes, boolean includeDefaultExclude) throws IOException {
        String[] files;
        HashSet<String> localDocNames = new HashSet<String>();
        for (String relativeFilePath : files = this.getSrcFiles(srcDir, includes, excludes, true, includeDefaultExclude)) {
            String baseName = FilenameUtils.removeExtension((String)relativeFilePath);
            localDocNames.add(baseName);
        }
        return localDocNames;
    }

    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws IOException {
        try {
            String filename = this.docNameToFilename(docName);
            File srcFile = new File(sourceDir, filename);
            Resource resource = (Resource)this.unmarshaller.unmarshal(srcFile);
            return resource;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void visitTranslationResources(String docName, Resource srcDoc, PushCommand.TranslationResourcesVisitor visitor) throws IOException {
        try {
            for (LocaleMapping locale : this.getOpts().getLocaleMapList()) {
                String filename = this.docNameToFilename(docName, locale);
                File transFile = new File(this.getOpts().getTransDir(), filename);
                if (!transFile.exists()) continue;
                TranslationsResource targetDoc = (TranslationsResource)this.unmarshaller.unmarshal(transFile);
                visitor.visit(locale, targetDoc);
            }
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }
}

