/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.codehaus.plexus.util.StringOutputStream;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.zanata.client.ZanataClient;
import org.zanata.client.commands.AppAbortStrategy;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.RuntimeExceptionStrategy;

public class ZanataClientTest {
    private static final Logger log = LoggerFactory.getLogger(ZanataClientTest.class);
    StringOutputStream out;
    StringOutputStream err;
    ZanataClient client;

    @BeforeMethod
    void before() {
        this.out = new StringOutputStream();
        this.err = new StringOutputStream();
        this.client = new ZanataClient((AppAbortStrategy)new RuntimeExceptionStrategy(), new PrintStream((OutputStream)this.out), new PrintStream((OutputStream)this.err));
    }

    @AfterMethod
    void after() {
        String errOutput;
        String outOutput = this.out.toString();
        if (!outOutput.isEmpty()) {
            log.debug("stdout:\n{}", (Object)outOutput);
        }
        if (!(errOutput = this.err.toString()).isEmpty()) {
            log.debug("stderr:\n{}", (Object)errOutput);
        }
    }

    @DataProvider(name="options")
    public static Object[][] createOptions() throws Exception {
        return ZanataClientTest.toGrid(new ZanataClient().getOptionsMap().values());
    }

    private static Object[][] toGrid(Collection<?> collection) throws Exception {
        Object[][] result = new Object[collection.size()][1];
        int i = 0;
        for (Object obj : collection) {
            result[i++] = new Object[]{obj};
        }
        return result;
    }

    @Test(dataProvider="options")
    public void testForAmbiguousOptions(BasicOptions cmd) throws Exception {
        new CmdLineParser((Object)cmd);
    }

    @Test(dataProvider="options")
    public void testHelpCommand(BasicOptions cmd) throws Exception {
        this.client.processArgs(new String[]{"help", cmd.getCommandName()});
    }

    @Test(dataProvider="options")
    public void testHelpOption(BasicOptions cmd) throws Exception {
        this.client.processArgs(new String[]{cmd.getCommandName(), "--help"});
    }

    @Test(dataProvider="options")
    public void testNoArgs(BasicOptions cmd) throws Exception {
        this.client.processArgs(new String[]{cmd.getCommandName()});
    }
}

