/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.push;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IMocksControl;
import org.junit.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.zanata.client.commands.glossary.push.GlossaryPoReader;
import org.zanata.client.commands.glossary.push.GlossaryPushOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.dto.Glossary;

@Test(groups={"unit-tests"})
public class GlossaryPoReaderTest {
    LocaleList locales = new LocaleList();
    GlossaryPoReader reader = new GlossaryPoReader();
    IMocksControl control = EasyMock.createControl();
    GlossaryPushOptions mockPushOption;
    private final File sourceFile = new File("src/test/resources/glossary/fuel_hi.po");
    private final File sourceFile2 = new File("src/test/resources/glossary/compendium-zh_TW.po");
    private final int sourceSize1 = 578;
    private final int sourceSize2 = 2645;
    private final int BATCH_SIZE = 50;

    @BeforeMethod
    void beforeMethod() {
        this.control.reset();
    }

    @BeforeTest
    public void prepare() {
        this.locales.add(new LocaleMapping("hi"));
    }

    <T> T createMock(String name, Class<T> toMock) {
        Object mock = this.control.createMock(name, toMock);
        return (T)mock;
    }

    @Test
    public void extractGlossaryTest() throws IOException {
        this.mockPushOption = this.createMock("mockPushGlossaryOption", GlossaryPushOptions.class);
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTransLang()).andReturn((Object)"hi").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTreatSourceCommentsAsTarget()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getBatchSize()).andReturn((Object)50).anyTimes();
        this.reader.setOpts(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        List glossaries = this.reader.extractGlossary(this.sourceFile);
        Assert.assertEquals((double)Math.ceil(11.0), (double)glossaries.size(), (double)50.0);
        Assert.assertEquals((long)50L, (long)((Glossary)glossaries.get(0)).getGlossaryEntries().size());
        Assert.assertEquals((long)50L, (long)((Glossary)glossaries.get(1)).getGlossaryEntries().size());
        Assert.assertEquals((long)28L, (long)((Glossary)glossaries.get(glossaries.size() - 1)).getGlossaryEntries().size());
    }

    @Test
    public void glossaryBatchTest() throws IOException {
        this.mockPushOption = this.createMock("mockPushGlossaryOption", GlossaryPushOptions.class);
        EasyMock.expect((Object)this.mockPushOption.getSourceLang()).andReturn((Object)"en-US").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTransLang()).andReturn((Object)"zh-Hants").anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getLocaleMapList()).andReturn((Object)this.locales).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getTreatSourceCommentsAsTarget()).andReturn((Object)false).anyTimes();
        EasyMock.expect((Object)this.mockPushOption.getBatchSize()).andReturn((Object)50).anyTimes();
        this.reader.setOpts(this.mockPushOption);
        EasyMock.replay((Object[])new Object[]{this.mockPushOption});
        List glossaries = this.reader.extractGlossary(this.sourceFile2);
        Assert.assertEquals((double)Math.ceil(52.0), (double)glossaries.size(), (double)50.0);
        Assert.assertEquals((long)50L, (long)((Glossary)glossaries.get(0)).getGlossaryEntries().size());
        Assert.assertEquals((long)50L, (long)((Glossary)glossaries.get(1)).getGlossaryEntries().size());
        Assert.assertEquals((long)45L, (long)((Glossary)glossaries.get(glossaries.size() - 1)).getGlossaryEntries().size());
    }
}

