/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.zanata.client.commands.ConfigurableProjectOptionsImpl;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushPullType;

class PushOptionsImpl
extends ConfigurableProjectOptionsImpl
implements PushOptions {
    List<String> includes;
    List<String> excludes;
    boolean defaultExcludes;
    String mergeType;
    boolean caseSensitive = true;
    boolean excludeLocaleFilenames = true;
    boolean copyTrans;
    boolean pushTrans;
    String pushType;
    File transDir;
    File srcDir;
    String sourceLang;
    int batchSize;

    PushOptionsImpl() {
    }

    public ZanataCommand initCommand() {
        return new PushCommand((PushOptions)this);
    }

    public String getCommandName() {
        return "push";
    }

    public String getCommandDescription() {
        return "Pushes source text to a Zanata project version so that it can be translated.";
    }

    public String getSourceLang() {
        return this.sourceLang;
    }

    public File getSrcDir() {
        return this.srcDir;
    }

    public File getTransDir() {
        return this.transDir;
    }

    public boolean getCopyTrans() {
        return this.copyTrans;
    }

    public String getMergeType() {
        return this.mergeType;
    }

    public PushPullType getPushType() {
        return PushPullType.fromString((String)this.pushType);
    }

    public List<String> getIncludes() {
        return this.includes;
    }

    public List<String> getExcludes() {
        return this.excludes;
    }

    public boolean getDefaultExcludes() {
        return this.defaultExcludes;
    }

    public void setSrcDir(File file) {
        this.srcDir = file;
    }

    @Deprecated
    public void setPushTrans(boolean pushTrans) {
        this.pushTrans = pushTrans;
        this.pushType = pushTrans ? PushPullType.Both.toString() : PushPullType.Source.toString();
    }

    public boolean getEnableModules() {
        return false;
    }

    public boolean isDryRun() {
        return false;
    }

    public boolean isRootModule() {
        return false;
    }

    public String getCurrentModule() {
        return "";
    }

    public Set<String> getAllModules() {
        return Collections.emptySet();
    }

    public boolean getDeleteObsoleteModules() {
        return false;
    }

    public String getDocNameRegex() {
        return null;
    }

    public String getModuleSuffix() {
        return null;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean getExcludeLocaleFilenames() {
        return this.excludeLocaleFilenames;
    }
}

