/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.rest.client.ZanataProxyFactory;

public abstract class ConfigurableCommand<O extends ConfigurableOptions>
implements ZanataCommand {
    private final O opts;
    private ZanataProxyFactory requestFactory;
    private boolean deprecated;
    private String deprecationMessage;

    public ConfigurableCommand(O opts, ZanataProxyFactory factory) {
        this.opts = opts;
        this.requestFactory = factory != null ? factory : OptionsUtil.createRequestFactory(opts);
    }

    public ConfigurableCommand(O opts) {
        this(opts, null);
    }

    public O getOpts() {
        return this.opts;
    }

    public ZanataProxyFactory getRequestFactory() {
        return this.requestFactory;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    @Override
    public String getDeprecationMessage() {
        return this.deprecationMessage;
    }

    public void deprecate(String deprecationMessage) {
        this.deprecated = true;
        this.deprecationMessage = deprecationMessage;
    }

    @Override
    public String getName() {
        return this.opts.getCommandName();
    }
}

