/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.GettextDirStrategy;
import org.zanata.client.commands.push.GettextPushStrategy;
import org.zanata.client.commands.push.PropertiesStrategy;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushPullType;
import org.zanata.client.commands.push.XliffStrategy;
import org.zanata.client.commands.push.XmlStrategy;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.client.util.ConsoleUtils;
import org.zanata.common.LocaleId;
import org.zanata.common.MergeType;
import org.zanata.rest.RestUtil;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PushCommand
extends PushPullCommand<PushOptions> {
    private static final Logger log = LoggerFactory.getLogger(PushCommand.class);
    private static final String UTF_8 = "UTF-8";
    private static final Map<String, AbstractPushStrategy> strategies = new HashMap<String, AbstractPushStrategy>();

    public PushCommand(PushOptions opts) {
        super(opts);
        strategies.put("utf8properties", new PropertiesStrategy(UTF_8));
        strategies.put("properties", new PropertiesStrategy());
        strategies.put("gettext", new GettextPushStrategy());
        strategies.put("podir", new GettextDirStrategy());
        strategies.put("xliff", new XliffStrategy());
        strategies.put("xml", new XmlStrategy());
    }

    public PushCommand(PushOptions opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory, sourceDocResource, translationResources, uri);
        strategies.put("utf8properties", new PropertiesStrategy(UTF_8));
        strategies.put("properties", new PropertiesStrategy());
        strategies.put("gettext", new GettextPushStrategy());
        strategies.put("podir", new GettextDirStrategy());
        strategies.put("xliff", new XliffStrategy());
        strategies.put("xml", new XmlStrategy());
    }

    private AbstractPushStrategy getStrategy(String strategyType) {
        AbstractPushStrategy strat = strategies.get(strategyType);
        if (strat == null) {
            throw new RuntimeException("unknown project type: " + ((PushOptions)this.getOpts()).getProjectType());
        }
        strat.setPushOptions((PushOptions)this.getOpts());
        strat.init();
        return strat;
    }

    private void logOptions() {
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info("Server: {}", (Object)((PushOptions)this.getOpts()).getUrl());
        log.info("Project: {}", (Object)((PushOptions)this.getOpts()).getProj());
        log.info("Version: {}", (Object)((PushOptions)this.getOpts()).getProjectVersion());
        log.info("Username: {}", (Object)((PushOptions)this.getOpts()).getUsername());
        log.info("Project type: {}", (Object)((PushOptions)this.getOpts()).getProjectType());
        log.info("Source language: {}", (Object)((PushOptions)this.getOpts()).getSourceLang());
        log.info("Copy previous translations: {}", (Object)((PushOptions)this.getOpts()).getCopyTrans());
        log.info("Merge type: {}", (Object)((PushOptions)this.getOpts()).getMergeType());
        if (this.pushTrans() && this.mergeAuto()) {
            log.info("Batch size: {}", (Object)((PushOptions)this.getOpts()).getBatchSize());
        }
        log.info("Enable modules: {}", (Object)((PushOptions)this.getOpts()).getEnableModules());
        if (((PushOptions)this.getOpts()).getEnableModules()) {
            log.info("Current module: {}", (Object)((PushOptions)this.getOpts()).getCurrentModule());
            if (((PushOptions)this.getOpts()).isRootModule()) {
                log.info("Root module: YES");
                if (log.isDebugEnabled()) {
                    log.debug("Modules: {}", (Object)StringUtils.join(((PushOptions)this.getOpts()).getAllModules(), (String)", "));
                }
            }
        }
        log.info("Include patterns: {}", (Object)StringUtils.join(((PushOptions)this.getOpts()).getIncludes(), (String)" "));
        log.info("Exclude patterns: {}", (Object)StringUtils.join(((PushOptions)this.getOpts()).getExcludes(), (String)" "));
        log.info("Case sensitive: {}", (Object)((PushOptions)this.getOpts()).getCaseSensitive());
        log.info("Default excludes: {}", (Object)((PushOptions)this.getOpts()).getDefaultExcludes());
        log.info("Exclude locale filenames: {}", (Object)((PushOptions)this.getOpts()).getExcludeLocaleFilenames());
        if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans) {
            log.info("Pushing target documents only");
            log.info("Locales to push: {}", (Object)((PushOptions)this.getOpts()).getLocaleMapList());
        } else if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Source) {
            log.info("Pushing source documents only");
        } else {
            log.info("Pushing source and target documents");
            log.info("Locales to push: {}", (Object)((PushOptions)this.getOpts()).getLocaleMapList());
        }
        log.info("Source directory (originals): {}", (Object)((PushOptions)this.getOpts()).getSrcDir());
        if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Both || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans) {
            log.info("Target base directory (translations): {}", (Object)((PushOptions)this.getOpts()).getTransDir());
        }
        if (((PushOptions)this.getOpts()).isDryRun()) {
            log.info("DRY RUN: no permanent changes will be made");
        }
    }

    private boolean mergeAuto() {
        return ((PushOptions)this.getOpts()).getMergeType().toUpperCase().equals(MergeType.AUTO.name());
    }

    private boolean pushSource() {
        return ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Source;
    }

    private boolean pushTrans() {
        return ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans;
    }

    @Override
    public void run() throws Exception {
        this.logOptions();
        if (((PushOptions)this.getOpts()).getBatchSize() <= 0) {
            throw new RuntimeException("Batch size needs to be 1 or more.");
        }
        this.pushCurrentModule();
        if (this.pushSource() && ((PushOptions)this.getOpts()).getEnableModules() && ((PushOptions)this.getOpts()).isRootModule()) {
            List<String> obsoleteDocs = this.getObsoleteDocNamesForProjectIterationFromServer();
            log.info("found {} docs in obsolete modules (or no module): {}", (Object)obsoleteDocs.size(), obsoleteDocs);
            if (((PushOptions)this.getOpts()).getDeleteObsoleteModules() && !obsoleteDocs.isEmpty()) {
                this.confirmWithUser("Do you want to delete all documents from the server which don't belong to any module in the Maven reactor?\n");
                this.deleteSourceDocsFromServer(obsoleteDocs);
            } else {
                log.warn("found {} docs in obsolete modules (or no module).  use -Dzanata.deleteObsoleteModules to delete them", (Object)obsoleteDocs.size());
            }
        }
    }

    protected List<String> getObsoleteDocNamesForProjectIterationFromServer() {
        if (!((PushOptions)this.getOpts()).getEnableModules()) {
            return Collections.emptyList();
        }
        List<ResourceMeta> remoteDocList = this.getDocListForProjectIterationFromServer();
        Pattern p = Pattern.compile(((PushOptions)this.getOpts()).getDocNameRegex());
        HashSet<String> modules = new HashSet<String>(((PushOptions)this.getOpts()).getAllModules());
        ArrayList<String> obsoleteDocs = new ArrayList<String>();
        for (ResourceMeta doc : remoteDocList) {
            String docName = doc.getName();
            Matcher matcher = p.matcher(docName);
            if (matcher.matches()) {
                String module = matcher.group(1);
                if (modules.contains(module)) {
                    log.debug("doc {} belongs to non-obsolete module {}", (Object)docName, (Object)module);
                    continue;
                }
                obsoleteDocs.add(docName);
                log.info("doc {} belongs to obsolete module {}", (Object)docName, (Object)module);
                continue;
            }
            obsoleteDocs.add(docName);
            log.warn("doc {} doesn't belong to any module", (Object)docName);
        }
        return obsoleteDocs;
    }

    private void pushCurrentModule() throws IOException {
        File sourceDir = ((PushOptions)this.getOpts()).getSrcDir();
        if (!sourceDir.exists()) {
            if (((PushOptions)this.getOpts()).getEnableModules()) {
                log.info("source directory '" + sourceDir + "' not found; skipping docs push for module " + ((PushOptions)this.getOpts()).getCurrentModule());
                return;
            }
            throw new RuntimeException("directory '" + sourceDir + "' does not exist - check srcDir option");
        }
        AbstractPushStrategy strat = this.getStrategy(((PushOptions)this.getOpts()).getProjectType());
        final StringSet extensions = strat.getExtensions();
        Set<String> localDocNames = strat.findDocNames(sourceDir, ((PushOptions)this.getOpts()).getIncludes(), ((PushOptions)this.getOpts()).getExcludes(), ((PushOptions)this.getOpts()).getDefaultExcludes(), ((PushOptions)this.getOpts()).getCaseSensitive(), ((PushOptions)this.getOpts()).getExcludeLocaleFilenames());
        for (String docName : localDocNames) {
            log.info("Found source document: {}", (Object)docName);
        }
        List<Object> obsoleteDocs = Collections.emptyList();
        if (this.pushSource()) {
            obsoleteDocs = this.getObsoleteDocsInModuleFromServer(localDocNames);
        }
        if (obsoleteDocs.isEmpty()) {
            if (localDocNames.isEmpty()) {
                log.info("no documents in module: {}; nothing to do", (Object)((PushOptions)this.getOpts()).getCurrentModule());
                return;
            }
        } else {
            log.warn("Found {} obsolete docs on the server which will be DELETED", (Object)obsoleteDocs.size());
            log.info("Obsolete docs: {}", obsoleteDocs);
        }
        if (this.pushTrans()) {
            if (((PushOptions)this.getOpts()).getLocaleMapList() == null) {
                throw new ConfigException("pushType set to '" + (Object)((Object)((PushOptions)this.getOpts()).getPushType()) + "', but zanata.xml contains no <locales>");
            }
            log.warn("pushType set to '" + (Object)((Object)((PushOptions)this.getOpts()).getPushType()) + "': existing translations on server may be overwritten/deleted");
            if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
                this.confirmWithUser("This will overwrite existing documents AND TRANSLATIONS on the server, and delete obsolete documents.\n");
            } else if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans) {
                this.confirmWithUser("This will overwrite existing TRANSLATIONS on the server.\n");
            }
        } else {
            this.confirmWithUser("This will overwrite existing source documents on the server, and delete obsolete documents.\n");
        }
        for (String localDocName : localDocNames) {
            final Resource srcDoc = strat.loadSrcDoc(sourceDir, localDocName);
            String qualifiedDocName = this.qualifiedDocName(localDocName);
            final String docUri = RestUtil.convertToDocumentURIId((String)qualifiedDocName);
            srcDoc.setName(qualifiedDocName);
            this.debug(srcDoc);
            if (this.pushSource()) {
                this.pushSrcDocToServer(docUri, srcDoc, extensions);
            }
            if (!this.pushTrans()) continue;
            strat.visitTranslationResources(localDocName, srcDoc, new TranslationResourcesVisitor(){

                @Override
                public void visit(LocaleMapping locale, TranslationsResource targetDoc) {
                    PushCommand.this.debug(targetDoc);
                    PushCommand.this.pushTargetDocToServer(docUri, locale, srcDoc, targetDoc, extensions);
                }
            });
        }
        this.deleteSourceDocsFromServer(obsoleteDocs);
    }

    private List<String> getObsoleteDocsInModuleFromServer(Set<String> localDocNames) {
        List<String> qualifiedDocNames = this.getQualifiedDocNamesForCurrentModuleFromServer();
        ArrayList<String> obsoleteDocs = new ArrayList<String>(qualifiedDocNames.size());
        for (String qualifiedDocName : qualifiedDocNames) {
            String unqualifiedDocName = this.unqualifiedDocName(qualifiedDocName);
            if (localDocNames.contains(unqualifiedDocName)) continue;
            obsoleteDocs.add(qualifiedDocName);
        }
        return obsoleteDocs;
    }

    private void deleteSourceDocsFromServer(List<String> qualifiedDocNames) {
        for (String qualifiedDocName : qualifiedDocNames) {
            this.deleteSourceDocFromServer(qualifiedDocName);
        }
    }

    private void pushSrcDocToServer(String docUri, Resource srcDoc, StringSet extensions) {
        if (!((PushOptions)this.getOpts()).isDryRun()) {
            log.info("pushing source doc [name={} size={}] to server", (Object)srcDoc.getName(), (Object)srcDoc.getTextFlows().size());
            boolean copyTrans = ((PushOptions)this.getOpts()).getCopyTrans();
            ConsoleUtils.startProgressFeedback();
            ClientResponse putResponse = this.sourceDocResource.putResource(docUri, srcDoc, (Set)extensions, copyTrans);
            ConsoleUtils.endProgressFeedback();
            ClientUtility.checkResult((ClientResponse)putResponse, (URI)this.uri);
        } else {
            log.info("pushing source doc [name={} size={}] to server (skipped due to dry run)", (Object)srcDoc.getName(), (Object)srcDoc.getTextFlows().size());
        }
    }

    public List<TranslationsResource> splitIntoBatch(TranslationsResource doc, int maxBatchSize) {
        ArrayList<TranslationsResource> targetDocList = new ArrayList<TranslationsResource>();
        int numTargets = doc.getTextFlowTargets().size();
        if (numTargets > maxBatchSize && this.mergeAuto()) {
            int numBatches = numTargets / maxBatchSize;
            if (numTargets % maxBatchSize != 0) {
                ++numBatches;
            }
            int fromIndex = 0;
            int toIndex = 0;
            for (int i = 1; i <= numBatches; ++i) {
                TranslationsResource resource = new TranslationsResource();
                resource.setExtensions(doc.getExtensions());
                resource.setLinks(doc.getLinks());
                resource.setRevision(doc.getRevision());
                toIndex = i * maxBatchSize > numTargets ? numTargets : i * maxBatchSize;
                resource.getTextFlowTargets().addAll(doc.getTextFlowTargets().subList(fromIndex, toIndex));
                fromIndex = i * maxBatchSize;
                targetDocList.add(resource);
            }
        } else {
            targetDocList.add(doc);
        }
        return targetDocList;
    }

    private void pushTargetDocToServer(String docUri, LocaleMapping locale, Resource srcDoc, TranslationsResource targetDoc, StringSet extensions) {
        if (!((PushOptions)this.getOpts()).isDryRun()) {
            log.info("pushing target doc [name={} size={} client-locale={}] to server [locale={}]", new Object[]{srcDoc.getName(), targetDoc.getTextFlowTargets().size(), locale.getLocalLocale(), locale.getLocale()});
            List<TranslationsResource> targetDocList = this.splitIntoBatch(targetDoc, ((PushOptions)this.getOpts()).getBatchSize());
            int totalDone = 0;
            for (TranslationsResource doc : targetDocList) {
                ConsoleUtils.startProgressFeedback();
                ClientResponse putTransResponse = this.translationResources.putTranslations(docUri, new LocaleId(locale.getLocale()), doc, (Set)extensions, ((PushOptions)this.getOpts()).getMergeType());
                ConsoleUtils.endProgressFeedback();
                ClientUtility.checkResult((ClientResponse)putTransResponse, (URI)this.uri);
                String entity = (String)putTransResponse.getEntity(String.class);
                if (entity != null && !entity.isEmpty()) {
                    log.warn("{}", (Object)entity);
                }
                log.info("Pushed " + (totalDone += doc.getTextFlowTargets().size()) + " of " + targetDoc.getTextFlowTargets().size() + " entries");
            }
        } else {
            log.info("pushing target doc [name={} size={} client-locale={}] to server [locale={}] (skipped due to dry run)", new Object[]{srcDoc.getName(), targetDoc.getTextFlowTargets().size(), locale.getLocalLocale(), locale.getLocale()});
        }
    }

    private void deleteSourceDocFromServer(String qualifiedDocName) {
        if (!((PushOptions)this.getOpts()).isDryRun()) {
            log.info("deleting resource {} from server", (Object)qualifiedDocName);
            String docUri = RestUtil.convertToDocumentURIId((String)qualifiedDocName);
            ClientResponse deleteResponse = this.sourceDocResource.deleteResource(docUri);
            ClientUtility.checkResult((ClientResponse)deleteResponse, (URI)this.uri);
        } else {
            log.info("deleting resource {} from server (skipped due to dry run)", (Object)qualifiedDocName);
        }
    }

    public static interface TranslationResourcesVisitor {
        public void visit(LocaleMapping var1, TranslationsResource var2);
    }
}

