/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.util;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class ConsoleUtils {
    private static final Timer timer = new Timer();
    private static final Map<TimerTaskType, TimerTask> activeTasks = new HashMap<TimerTaskType, TimerTask>();

    public static void startProgressFeedback() {
        if (activeTasks.containsKey((Object)TimerTaskType.ProgressFeedback)) {
            activeTasks.get((Object)TimerTaskType.ProgressFeedback).cancel();
            activeTasks.remove((Object)TimerTaskType.ProgressFeedback);
        }
        TimeProgressTask progressFeedbackTask = new TimeProgressTask();
        timer.schedule((TimerTask)progressFeedbackTask, 0L, 1000L);
        activeTasks.put(TimerTaskType.ProgressFeedback, progressFeedbackTask);
    }

    public static void endProgressFeedback() {
        TimerTask task = activeTasks.remove((Object)TimerTaskType.ProgressFeedback);
        if (task != null) {
            task.cancel();
        }
    }

    private static String formatDuration(Date start, Date end) {
        long durationInSecs = (end.getTime() - start.getTime()) / 1000L;
        StringBuilder formattedDuration = new StringBuilder();
        long minutes = durationInSecs / 60L;
        if (minutes > 0L) {
            formattedDuration.append(minutes + " mins");
        }
        long secs = durationInSecs % 60L;
        if (formattedDuration.length() > 0) {
            formattedDuration.append(":");
        }
        formattedDuration.append(secs + " secs");
        return formattedDuration.toString();
    }

    private static class TimeProgressTask
    extends TimerTask {
        private Date start;

        private TimeProgressTask() {
        }

        @Override
        public void run() {
            if (this.start == null) {
                this.start = new Date();
            }
            System.out.print(".");
        }

        @Override
        public boolean cancel() {
            if (this.start != null) {
                System.out.print(" " + ConsoleUtils.formatDuration(this.start, new Date()));
                System.out.println();
            }
            return super.cancel();
        }
    }

    private static enum TimerTaskType {
        ProgressFeedback;

    }
}

