/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.DummyResponse;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PublicanPullCommand;
import org.zanata.client.commands.PublicanPullOptions;
import org.zanata.client.commands.PublicanPullOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.RestUtil;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

@Test(groups={"unit-tests"})
public class PublicanPullCommandTest {
    @Mock
    private ISourceDocResource mockSourceDocResource;
    @Mock
    private ITranslatedDocResource mockTranslationResources;

    @BeforeMethod
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)this);
    }

    public void publicanPullPo() throws Exception {
        this.publicanPull(false, false);
    }

    public void publicanPullPotAndPo() throws Exception {
        this.publicanPull(true, false);
    }

    @Test
    public void publicanPullPotAndPoWithLocaleMapping() throws Exception {
        this.publicanPull(true, true);
    }

    private void publicanPull(boolean exportPot, boolean mapLocale) throws Exception {
        PublicanPullOptionsImpl opts = new PublicanPullOptionsImpl();
        String projectSlug = "project";
        opts.setProj(projectSlug);
        String versionSlug = "1.0";
        opts.setProjectVersion(versionSlug);
        opts.setDstDir(new File("target/test-output/test2"));
        opts.setExportPot(exportPot);
        opts.setProjectConfig(new File("src/test/resources/test2/zanata.xml"));
        OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
        if (mapLocale) {
            LocaleList locales = new LocaleList();
            locales.add(new LocaleMapping("ja", "ja-JP"));
            opts.setLocaleMapList(locales);
        }
        ArrayList<ResourceMeta> resourceMetaList = new ArrayList<ResourceMeta>();
        resourceMetaList.add(new ResourceMeta("RPM"));
        resourceMetaList.add(new ResourceMeta("sub/RPM"));
        Mockito.when((Object)this.mockSourceDocResource.get(null)).thenReturn(new DummyResponse(Response.Status.OK, resourceMetaList));
        Resource rpmResource = new Resource("RPM");
        StringSet ext = new StringSet("comment;gettext");
        Mockito.when((Object)this.mockSourceDocResource.getResource(RestUtil.convertToDocumentURIId((String)rpmResource.getName()), (Set)ext)).thenReturn(new DummyResponse<Resource>(Response.Status.OK, rpmResource));
        Resource subRpmResource = new Resource("sub/RPM");
        Mockito.when((Object)this.mockSourceDocResource.getResource(RestUtil.convertToDocumentURIId((String)subRpmResource.getName()), (Set)ext)).thenReturn(new DummyResponse<Resource>(Response.Status.OK, subRpmResource));
        LocaleId expectedLocale = mapLocale ? new LocaleId("ja") : new LocaleId("ja-JP");
        TranslationsResource rpmTransJa = new TranslationsResource();
        this.mockExpectGetTranslationsAndReturnResponse("RPM", expectedLocale, rpmTransJa);
        this.mockExpectGetTranslationsAndReturnResponse("sub/RPM", expectedLocale, null);
        ZanataProxyFactory mockRequestFactory = (ZanataProxyFactory)Mockito.mock(ZanataProxyFactory.class);
        PublicanPullCommand cmd = new PublicanPullCommand((PublicanPullOptions)opts, mockRequestFactory, this.mockSourceDocResource, this.mockTranslationResources, new URI("http://example.com/"));
        cmd.run();
    }

    private void mockExpectGetTranslationsAndReturnResponse(String id, LocaleId locale, TranslationsResource entity) {
        String docUri = RestUtil.convertToDocumentURIId((String)id);
        StringSet ext = new StringSet("comment;gettext");
        if (entity != null) {
            Mockito.when((Object)this.mockTranslationResources.getTranslations(docUri, locale, (Set)ext)).thenReturn(new DummyResponse<TranslationsResource>(Response.Status.OK, entity));
        } else {
            Mockito.when((Object)this.mockTranslationResources.getTranslations(docUri, locale, (Set)ext)).thenReturn(new DummyResponse<TranslationsResource>(Response.Status.NOT_FOUND, entity));
        }
    }
}

