/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.config;

import java.io.File;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import junit.framework.TestCase;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.config.ZanataConfig;

public class ZanataConfigTest
extends TestCase {
    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ZanataConfig.class});
    Unmarshaller unmarshaller = this.jc.createUnmarshaller();
    Marshaller marshaller = this.jc.createMarshaller();
    File zanataProjectXml = new File(System.getProperty("user.dir"), "target/zanata.xml");
    File zanataUserFile = new File(System.getProperty("user.dir"), "target/zanata.ini");

    public ZanataConfigTest() throws Exception {
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
    }

    public void testWriteReadProject() throws Exception {
        this.writeProject();
        this.readProject();
    }

    void writeProject() throws Exception {
        ZanataConfig config = new ZanataConfig();
        config.setUrl(new URL("http://example.com"));
        config.setProject("project");
        config.setProjectVersion("version");
        config.getLocales().add(new LocaleMapping("fr", "fr-FR"));
        config.getLocales().add(new LocaleMapping("  zh-CN  "));
        this.marshaller.marshal((Object)config, this.zanataProjectXml);
    }

    void readProject() throws Exception {
        ZanataConfig config = (ZanataConfig)this.unmarshaller.unmarshal(this.zanataProjectXml);
        ZanataConfigTest.assertEquals((Object)new URL("http://example.com"), (Object)config.getUrl());
        ZanataConfigTest.assertEquals((String)"project", (String)config.getProject());
        ZanataConfigTest.assertEquals((String)"version", (String)config.getProjectVersion());
        LocaleList locales = config.getLocales();
        ZanataConfigTest.assertEquals((int)2, (int)locales.size());
        ZanataConfigTest.assertEquals((String)"fr", (String)locales.get(0).getLocale());
        ZanataConfigTest.assertEquals((String)"fr-FR", (String)locales.get(0).getMapFrom());
        ZanataConfigTest.assertEquals((String)"zh-CN", (String)locales.get(1).getLocale());
        ZanataConfigTest.assertNull((Object)locales.get(1).getMapFrom());
    }

    public void testWriteReadUser() throws Exception {
        this.writeUser();
        this.readUser();
    }

    void writeUser() throws Exception {
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration(this.zanataUserFile);
        config.setProperty("zanata.url", (Object)new URL("http://zanata.example.com/"));
        config.setProperty("zanata.username", (Object)"admin");
        config.setProperty("zanata.key", (Object)"b6d7044e9ee3b2447c28fb7c50d86d98");
        config.setProperty("zanata.debug", (Object)false);
        config.setProperty("zanata.errors", (Object)true);
        config.save();
    }

    void readUser() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addConfiguration((Configuration)new SystemConfiguration());
        config.addConfiguration((Configuration)new HierarchicalINIConfiguration(this.zanataUserFile));
        String user = config.getString("zanata.username");
        ZanataConfigTest.assertEquals((String)"admin", (String)user);
        boolean debug = config.getBoolean("zanata.debug");
        ZanataConfigTest.assertFalse((boolean)debug);
        boolean errors = config.getBoolean("zanata.errors");
        ZanataConfigTest.assertTrue((boolean)errors);
    }
}

