/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.XliffStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

@Test(groups={"unit-tests"})
public class XliffPushStrategyTest {
    @Mock
    private PushOptions mockPushOption;
    private LocaleList locales = new LocaleList();
    private XliffStrategy xliffStrategy;
    private List<String> include;
    private List<String> exclude;
    private final File sourceDir = new File("src/test/resources/xliffDir");
    private final File sourceDir2 = new File("src/test/resources/xliffDir2");
    private final String sourceLocale = "en-US";

    @BeforeTest
    public void prepare() {
        this.locales.add(new LocaleMapping("de"));
        this.locales.add(new LocaleMapping("fr"));
    }

    @BeforeMethod
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)this);
        this.xliffStrategy = new XliffStrategy();
        this.include = new ArrayList<String>();
        this.exclude = new ArrayList<String>();
    }

    @Test
    public void findDocNamesTest() throws IOException {
        this.include.add("**/**StringResource_en_US*");
        Mockito.when((Object)this.mockPushOption.getLocaleMapList()).thenReturn((Object)this.locales);
        Mockito.when((Object)this.mockPushOption.getSourceLang()).thenReturn((Object)"en-US");
        Mockito.when((Object)this.mockPushOption.getDefaultExcludes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getCaseSensitive()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getExcludeLocaleFilenames()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getValidate()).thenReturn((Object)"xsd");
        this.xliffStrategy.setPushOptions(this.mockPushOption);
        Set localDocNames = this.xliffStrategy.findDocNames(this.sourceDir, this.include, this.exclude, this.mockPushOption.getDefaultExcludes(), this.mockPushOption.getCaseSensitive(), this.mockPushOption.getExcludeLocaleFilenames());
        Assert.assertEquals((long)3L, (long)localDocNames.size());
    }

    @Test
    public void loadSrcDocTest() throws IOException {
        this.include.add("**/**StringResource_en_US*");
        Mockito.when((Object)this.mockPushOption.getTransDir()).thenReturn((Object)this.sourceDir);
        Mockito.when((Object)this.mockPushOption.getLocaleMapList()).thenReturn((Object)this.locales);
        Mockito.when((Object)this.mockPushOption.getSourceLang()).thenReturn((Object)"en-US");
        Mockito.when((Object)this.mockPushOption.getDefaultExcludes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getCaseSensitive()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getExcludeLocaleFilenames()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getValidate()).thenReturn((Object)"xsd");
        this.xliffStrategy.setPushOptions(this.mockPushOption);
        Set localDocNames = this.xliffStrategy.findDocNames(this.sourceDir, this.include, this.exclude, this.mockPushOption.getDefaultExcludes(), this.mockPushOption.getCaseSensitive(), this.mockPushOption.getExcludeLocaleFilenames());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String docName : localDocNames) {
            Resource srcDoc = this.xliffStrategy.loadSrcDoc(this.sourceDir, docName);
            resourceList.add(srcDoc);
            PushCommand.TranslationResourcesVisitor visitor = (PushCommand.TranslationResourcesVisitor)Mockito.mock(PushCommand.TranslationResourcesVisitor.class);
            LocaleMapping loc = srcDoc.getName().equals("dir1/StringResource") ? new LocaleMapping("de") : new LocaleMapping("fr");
            this.xliffStrategy.visitTranslationResources(docName, srcDoc, visitor);
            ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)visitor)).visit((LocaleMapping)Matchers.eq((Object)loc), (TranslationsResource)Matchers.isA(TranslationsResource.class));
        }
        Assert.assertEquals((long)3L, (long)resourceList.size());
    }

    @Test
    public void loadSrcDocTestWithCaseSensitive() throws IOException {
        this.include.add("StringResource_en*");
        Mockito.when((Object)this.mockPushOption.getSourceLang()).thenReturn((Object)"en-US");
        Mockito.when((Object)this.mockPushOption.getLocaleMapList()).thenReturn((Object)this.locales);
        Mockito.when((Object)this.mockPushOption.getCaseSensitive()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getExcludeLocaleFilenames()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getDefaultExcludes()).thenReturn((Object)false);
        Mockito.when((Object)this.mockPushOption.getValidate()).thenReturn((Object)"xsd");
        this.xliffStrategy.setPushOptions(this.mockPushOption);
        Set localDocNames = this.xliffStrategy.findDocNames(this.sourceDir2, this.include, this.exclude, this.mockPushOption.getDefaultExcludes(), this.mockPushOption.getCaseSensitive(), this.mockPushOption.getExcludeLocaleFilenames());
        Assert.assertEquals((long)5L, (long)localDocNames.size());
    }

    @Test
    public void loadSrcDocTestWithoutCaseSensitive() throws IOException {
        this.include.add("STRINGRESOURCE_en*");
        Mockito.when((Object)this.mockPushOption.getSourceLang()).thenReturn((Object)"en-US");
        Mockito.when((Object)this.mockPushOption.getLocaleMapList()).thenReturn((Object)this.locales);
        Mockito.when((Object)this.mockPushOption.getCaseSensitive()).thenReturn((Object)false);
        Mockito.when((Object)this.mockPushOption.getExcludeLocaleFilenames()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getDefaultExcludes()).thenReturn((Object)false);
        Mockito.when((Object)this.mockPushOption.getValidate()).thenReturn((Object)"xsd");
        this.xliffStrategy.setPushOptions(this.mockPushOption);
        Set localDocNames = this.xliffStrategy.findDocNames(this.sourceDir2, this.include, this.exclude, this.mockPushOption.getDefaultExcludes(), this.mockPushOption.getCaseSensitive(), this.mockPushOption.getExcludeLocaleFilenames());
        Assert.assertEquals((long)6L, (long)localDocNames.size());
    }

    @Test
    public void loadSrcDocTestWithExcludeFileOption() throws IOException {
        this.include.add("**/**StringResource_en_US*");
        this.exclude.add("**/*StringResource*");
        Mockito.when((Object)this.mockPushOption.getTransDir()).thenReturn((Object)this.sourceDir);
        Mockito.when((Object)this.mockPushOption.getLocaleMapList()).thenReturn((Object)this.locales);
        Mockito.when((Object)this.mockPushOption.getSourceLang()).thenReturn((Object)"en-US");
        Mockito.when((Object)this.mockPushOption.getDefaultExcludes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getCaseSensitive()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getExcludeLocaleFilenames()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getValidate()).thenReturn((Object)"xsd");
        this.xliffStrategy.setPushOptions(this.mockPushOption);
        Set localDocNames = this.xliffStrategy.findDocNames(this.sourceDir, this.include, this.exclude, this.mockPushOption.getDefaultExcludes(), this.mockPushOption.getCaseSensitive(), this.mockPushOption.getExcludeLocaleFilenames());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String docName : localDocNames) {
            Resource srcDoc = this.xliffStrategy.loadSrcDoc(this.sourceDir, docName);
            resourceList.add(srcDoc);
            PushCommand.TranslationResourcesVisitor visitor = (PushCommand.TranslationResourcesVisitor)Mockito.mock(PushCommand.TranslationResourcesVisitor.class);
            LocaleMapping loc = srcDoc.getName().equals("dir1/StringResource") ? new LocaleMapping("de") : new LocaleMapping("fr");
            this.xliffStrategy.visitTranslationResources(docName, srcDoc, visitor);
            ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)visitor)).visit((LocaleMapping)Matchers.eq((Object)loc), (TranslationsResource)Matchers.isA(TranslationsResource.class));
        }
        Assert.assertEquals((long)0L, (long)resourceList.size());
    }

    @Test
    public void loadSrcDocTestWithExcludeOption() throws IOException {
        this.include.add("**/**StringResource_en_US*");
        this.exclude.add("**/dir2/*");
        Mockito.when((Object)this.mockPushOption.getTransDir()).thenReturn((Object)this.sourceDir);
        Mockito.when((Object)this.mockPushOption.getLocaleMapList()).thenReturn((Object)this.locales);
        Mockito.when((Object)this.mockPushOption.getSourceLang()).thenReturn((Object)"en-US");
        Mockito.when((Object)this.mockPushOption.getDefaultExcludes()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getCaseSensitive()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getExcludeLocaleFilenames()).thenReturn((Object)true);
        Mockito.when((Object)this.mockPushOption.getValidate()).thenReturn((Object)"xsd");
        this.xliffStrategy.setPushOptions(this.mockPushOption);
        Set localDocNames = this.xliffStrategy.findDocNames(this.sourceDir, this.include, this.exclude, this.mockPushOption.getDefaultExcludes(), this.mockPushOption.getCaseSensitive(), this.mockPushOption.getExcludeLocaleFilenames());
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        for (String docName : localDocNames) {
            Resource srcDoc = this.xliffStrategy.loadSrcDoc(this.sourceDir, docName);
            resourceList.add(srcDoc);
            PushCommand.TranslationResourcesVisitor visitor = (PushCommand.TranslationResourcesVisitor)Mockito.mock(PushCommand.TranslationResourcesVisitor.class);
            LocaleMapping loc = srcDoc.getName().equals("dir1/StringResource") ? new LocaleMapping("de") : new LocaleMapping("fr");
            this.xliffStrategy.visitTranslationResources(docName, srcDoc, visitor);
            ((PushCommand.TranslationResourcesVisitor)Mockito.verify((Object)visitor)).visit((LocaleMapping)Matchers.eq((Object)loc), (TranslationsResource)Matchers.isA(TranslationsResource.class));
        }
        Assert.assertEquals((long)1L, (long)resourceList.size());
    }
}

