/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.zanata.client.commands.AppAbortStrategy;
import org.zanata.client.commands.ArgsUtil;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.BasicOptionsImpl;
import org.zanata.client.commands.ListRemoteOptionsImpl;
import org.zanata.client.commands.PublicanPullOptionsImpl;
import org.zanata.client.commands.PublicanPushOptionsImpl;
import org.zanata.client.commands.PutProjectOptionsImpl;
import org.zanata.client.commands.PutUserOptionsImpl;
import org.zanata.client.commands.PutVersionOptionsImpl;
import org.zanata.client.commands.SystemExitStrategy;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.stats.GetStatisticsOptionsImpl;
import org.zanata.util.VersionUtility;

public class ZanataClient
extends BasicOptionsImpl {
    private String command;
    private boolean version;
    @Argument(index=1, multiValued=true)
    private final List<String> arguments = new ArrayList<String>();
    private final CmdLineParser parser = new CmdLineParser((Object)this);
    private final LinkedHashMap<String, BasicOptions> optionsMap = new LinkedHashMap();
    private final AppAbortStrategy abortStrategy;
    private final PrintStream out;
    private final PrintStream err;

    public static void main(String[] args) {
        ZanataClient tool = new ZanataClient();
        tool.processArgs(args);
    }

    @Override
    public ZanataCommand initCommand() {
        return null;
    }

    public ZanataClient() {
        this(new SystemExitStrategy(), System.out, System.err);
    }

    public ZanataClient(AppAbortStrategy strategy, PrintStream out, PrintStream err) {
        this.abortStrategy = strategy;
        this.out = out;
        this.err = err;
        this.getOptionsMap().put("listremote", new ListRemoteOptionsImpl());
        this.getOptionsMap().put("publican-push", new PublicanPushOptionsImpl());
        this.getOptionsMap().put("publican-pull", new PublicanPullOptionsImpl());
        this.getOptionsMap().put("putproject", new PutProjectOptionsImpl());
        this.getOptionsMap().put("putuser", new PutUserOptionsImpl());
        this.getOptionsMap().put("putversion", new PutVersionOptionsImpl());
        this.getOptionsMap().put("getstatistics", new GetStatisticsOptionsImpl());
    }

    @Override
    public String getCommandName() {
        return "zanataj";
    }

    @Override
    public String getCommandDescription() {
        return "Zanata Java command-line client";
    }

    protected LinkedHashMap<String, BasicOptions> getOptionsMap() {
        return this.optionsMap;
    }

    protected void processArgs(String ... args) {
        block11: {
            this.arguments.clear();
            try {
                this.parser.parseArgument(args);
            }
            catch (CmdLineException e) {
                if (this.getHelp() || args.length == 0) break block11;
                this.err.println(e.getMessage());
                this.printHelp(this.err);
                this.abortStrategy.abort(null);
            }
        }
        if (this.getHelp() && this.command == null) {
            this.printHelp(this.out);
            return;
        }
        if (this.version) {
            this.out.println(this.getCommandName());
            VersionUtility.printVersions(ZanataClient.class, (PrintStream)this.out);
            return;
        }
        if ("help".equals(this.command)) {
            this.setHelp(true);
            this.command = null;
            if (this.arguments.size() != 0) {
                this.command = this.arguments.remove(0);
            }
        }
        if (this.command == null) {
            this.printHelp(this.out);
            return;
        }
        String[] otherArgs = this.arguments.toArray(new String[0]);
        try {
            BasicOptions options = this.getOptionsMap().get(this.command);
            if (options == null) {
                this.err.println("Unknown command '" + this.command + "'");
                this.printHelp(this.err);
                this.abortStrategy.abort(null);
            } else {
                new ArgsUtil(this.abortStrategy, this.out, this.err).process(otherArgs, options);
            }
        }
        catch (Exception e) {
            ArgsUtil.handleException(e, this.getErrors(), this.abortStrategy);
        }
    }

    private void printHelp(PrintStream out) {
        out.println("Usage: " + this.getCommandName() + " [OPTION]... <command> [COMMANDOPTION]...");
        out.println(this.getCommandDescription());
        out.println();
        this.parser.printUsage((OutputStream)out);
        out.println();
        out.println("Type '" + this.getCommandName() + " help <command>' for help on a specific command.");
        out.println();
        out.println("Available commands:");
        for (String cmd : this.getOptionsMap().keySet()) {
            out.println("  " + cmd);
        }
    }

    @Option(name="--version", aliases={"-v"}, usage="Output version information and exit")
    public void setVersion(boolean version) {
        this.version = version;
    }

    @Argument(index=0, usage="Command name", metaVar="<command>")
    public void setCommand(String command) {
        this.command = command;
        this.parser.stopOptionParsing();
    }
}

