/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.adapter.po.PoWriter2;
import org.zanata.client.commands.ConfigurableProjectCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PublicanPullOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.common.LocaleId;
import org.zanata.rest.RestUtil;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PublicanPullCommand
extends ConfigurableProjectCommand<PublicanPullOptions> {
    private static final Logger log = LoggerFactory.getLogger(PublicanPullCommand.class);
    private final ISourceDocResource sourceDocResource;
    private final ITranslatedDocResource translationResources;
    private final URI uri;

    public PublicanPullCommand(PublicanPullOptions opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory);
        this.sourceDocResource = sourceDocResource;
        this.translationResources = translationResources;
        this.uri = uri;
        this.deprecate("please use \"pull\" with project type \"podir\"");
    }

    private PublicanPullCommand(PublicanPullOptions opts, ZanataProxyFactory factory) {
        this(opts, factory, factory.getSourceDocResource(opts.getProj(), opts.getProjectVersion()), factory.getTranslatedDocResource(opts.getProj(), opts.getProjectVersion()), factory.getResourceURI(opts.getProj(), opts.getProjectVersion()));
    }

    public PublicanPullCommand(PublicanPullOptions opts) {
        this(opts, OptionsUtil.createRequestFactory(opts));
    }

    @Override
    protected String getProjectType() {
        return "podir";
    }

    @Override
    public void run() throws Exception {
        log.info("Server: {}", (Object)((PublicanPullOptions)this.getOpts()).getUrl());
        log.info("Project: {}", (Object)((PublicanPullOptions)this.getOpts()).getProj());
        log.info("Version: {}", (Object)((PublicanPullOptions)this.getOpts()).getProjectVersion());
        log.info("Username: {}", (Object)((PublicanPullOptions)this.getOpts()).getUsername());
        if (((PublicanPullOptions)this.getOpts()).getExportPot()) {
            log.info("Exporting source and target (translation) documents");
            log.info("POT directory (originals): {}", (Object)((PublicanPullOptions)this.getOpts()).getDstDirPot());
        } else {
            log.info("Exporting target documents (translations) only");
        }
        log.info("PO base directory (translations): {}", (Object)((PublicanPullOptions)this.getOpts()).getDstDir());
        LocaleList locales = ((PublicanPullOptions)this.getOpts()).getLocaleMapList();
        if (locales == null) {
            throw new ConfigException("no locales specified");
        }
        PoWriter2 poWriter = new PoWriter2();
        StringSet extensions = new StringSet("gettext;comment");
        ClientResponse listResponse = this.sourceDocResource.get(null);
        ClientUtility.checkResult((ClientResponse)listResponse, (URI)this.uri);
        List resourceMetaList = (List)listResponse.getEntity();
        for (ResourceMeta resourceMeta : resourceMetaList) {
            String docName = resourceMeta.getName();
            String docUri = RestUtil.convertToDocumentURIId((String)docName);
            ClientResponse resourceResponse = this.sourceDocResource.getResource(docUri, (Set)extensions);
            ClientUtility.checkResult((ClientResponse)resourceResponse, (URI)this.uri);
            Resource doc = (Resource)resourceResponse.getEntity();
            if (((PublicanPullOptions)this.getOpts()).getExportPot()) {
                log.info("writing POT for document {}", (Object)docName);
                poWriter.writePotToDir(((PublicanPullOptions)this.getOpts()).getDstDirPot(), doc);
            }
            for (LocaleMapping locMapping : locales) {
                LocaleId locale = new LocaleId(locMapping.getLocale());
                ClientResponse transResponse = this.translationResources.getTranslations(docUri, locale, (Set)extensions);
                if (transResponse.getResponseStatus() == Response.Status.NOT_FOUND) {
                    log.info("no translations found in locale {} for document {}", (Object)locale, (Object)docName);
                    continue;
                }
                ClientUtility.checkResult((ClientResponse)transResponse, (URI)this.uri);
                TranslationsResource targetDoc = (TranslationsResource)transResponse.getEntity();
                String localeDir = locMapping.getLocalLocale();
                log.info("writing PO translations in locale {} for document {}", (Object)locale, (Object)docName);
                poWriter.writePo(((PublicanPullOptions)this.getOpts()).getDstDir(), doc, localeDir, targetDoc);
            }
        }
    }
}

