/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import org.zanata.adapter.properties.PropWriter;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullStrategy;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PropertiesStrategy
implements PullStrategy {
    StringSet extensions = new StringSet("comment");
    private PullOptions pullOptions;

    protected PullOptions getPullOptions() {
        return this.pullOptions;
    }

    @Override
    public void setPullOptions(PullOptions opts) {
        this.pullOptions = opts;
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return false;
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        PropWriter.write((Resource)doc, (File)this.getPullOptions().getSrcDir());
    }

    @Override
    public void writeTransFile(Resource doc, String docName, LocaleMapping localeMapping, TranslationsResource targetDoc) throws IOException {
        boolean createSkeletons = this.getPullOptions().getCreateSkeletons();
        if (createSkeletons) {
            PropWriter.write((Resource)doc, (TranslationsResource)targetDoc, (File)this.getPullOptions().getTransDir(), (String)docName, (String)localeMapping.getJavaLocale(), (boolean)createSkeletons);
        } else {
            PropWriter.write(null, (TranslationsResource)targetDoc, (File)this.getPullOptions().getTransDir(), (String)docName, (String)localeMapping.getJavaLocale(), (boolean)createSkeletons);
        }
    }
}

