/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.InputStream;
import java.net.URI;
import java.util.List;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.RawPullStrategy;
import org.zanata.client.commands.push.PushPullType;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.IFileResource;

public class RawPullCommand
extends PushPullCommand<PullOptions> {
    private static final Logger log = LoggerFactory.getLogger(RawPullCommand.class);
    private IFileResource fileResource = this.getRequestFactory().getFileResource();

    public RawPullCommand(PullOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws Exception {
        boolean pullTarget;
        PullCommand.logOptions(log, (PullOptions)this.getOpts());
        if (((PullOptions)this.getOpts()).isDryRun()) {
            log.info("DRY RUN: no permanent changes will be made");
        }
        log.warn("Using EXPERIMENTAL project type 'raw'.");
        LocaleList locales = ((PullOptions)this.getOpts()).getLocaleMapList();
        if (locales == null) {
            throw new ConfigException("no locales specified");
        }
        RawPullStrategy strat = new RawPullStrategy();
        strat.setPullOptions((PullOptions)this.getOpts());
        List<String> docNamesForModule = this.getQualifiedDocNamesForCurrentModuleFromServer();
        if (docNamesForModule.isEmpty()) {
            log.info("No documents in remote module: {}; nothing to do", (Object)((PullOptions)this.getOpts()).getCurrentModule());
            return;
        }
        log.info("Pulling {} docs for this module from the server", (Object)docNamesForModule.size());
        log.debug("Doc names: {}", docNamesForModule);
        PushPullType pullType = ((PullOptions)this.getOpts()).getPullType();
        boolean pullSrc = pullType == PushPullType.Both || pullType == PushPullType.Source;
        boolean bl = pullTarget = pullType == PushPullType.Both || pullType == PushPullType.Trans;
        if (pullSrc) {
            log.warn("Pull Type set to '" + (Object)((Object)pullType) + "': existing source-language files may be overwritten/deleted");
            this.confirmWithUser("This will overwrite/delete any existing documents and translations in the above directories.\n");
        } else {
            this.confirmWithUser("This will overwrite/delete any existing translations in the above directory.\n");
        }
        for (String qualifiedDocName : docNamesForModule) {
            String localDocName = this.unqualifiedDocName(qualifiedDocName);
            if (pullSrc) {
                ClientResponse response = this.fileResource.downloadSourceFile(((PullOptions)this.getOpts()).getProj(), ((PullOptions)this.getOpts()).getProjectVersion(), "raw", qualifiedDocName);
                if (response.getResponseStatus() == Response.Status.NOT_FOUND) {
                    log.warn("No raw source document is available for [{}]. Skipping.", (Object)qualifiedDocName);
                } else {
                    ClientUtility.checkResult((ClientResponse)response, (URI)this.uri);
                    InputStream srcDoc = (InputStream)response.getEntity(InputStream.class);
                    if (srcDoc != null) {
                        strat.writeSrcFile(localDocName, srcDoc);
                    }
                }
            }
            if (!pullTarget) continue;
            for (LocaleMapping locMapping : locales) {
                LocaleId locale = new LocaleId(locMapping.getLocale());
                ClientResponse response = this.fileResource.downloadTranslationFile(((PullOptions)this.getOpts()).getProj(), ((PullOptions)this.getOpts()).getProjectVersion(), locale.getId(), "baked", qualifiedDocName);
                if (response.getResponseStatus() == Response.Status.NOT_FOUND) {
                    log.info("No raw translation document found in locale {} for document [{}]", (Object)locale, (Object)qualifiedDocName);
                    continue;
                }
                ClientUtility.checkResult((ClientResponse)response, (URI)this.uri);
                InputStream transDoc = (InputStream)response.getEntity(InputStream.class);
                if (transDoc == null) continue;
                strat.writeTransFile(localDocName, locMapping, transDoc);
            }
        }
    }
}

