/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.zanata.adapter.properties.PropReader;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.ContentState;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PropertiesStrategy
extends AbstractPushStrategy {
    private static final String ISO_8859_1 = "ISO-8859-1";
    private PropReader propReader;
    private final String charset;

    public PropertiesStrategy() {
        this(ISO_8859_1);
    }

    public PropertiesStrategy(String charset) {
        super(new StringSet("comment"), ".properties");
        this.charset = charset;
    }

    @Override
    public void init() {
        this.propReader = new PropReader(this.charset, new LocaleId(this.getOpts().getSourceLang()), ContentState.Approved);
    }

    @Override
    public Set<String> findDocNames(File srcDir, List<String> includes, List<String> excludes, boolean useDefaultExclude, boolean caseSensitive, boolean excludeLocaleFilenames) throws IOException {
        String[] files;
        HashSet<String> localDocNames = new HashSet<String>();
        for (String relativeFilePath : files = this.getSrcFiles(srcDir, includes, excludes, excludeLocaleFilenames, useDefaultExclude, caseSensitive)) {
            String baseName = FilenameUtils.removeExtension((String)relativeFilePath);
            localDocNames.add(baseName);
        }
        return localDocNames;
    }

    private Resource loadResource(String docName, File propFile) throws IOException {
        Resource doc = new Resource(docName);
        this.propReader.extractTemplate(doc, (InputStream)new FileInputStream(propFile));
        return doc;
    }

    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws IOException {
        String filename = this.docNameToFilename(docName);
        File propFile = new File(sourceDir, filename);
        return this.loadResource(docName, propFile);
    }

    private TranslationsResource loadTranslationsResource(Resource srcDoc, File transFile) throws IOException {
        TranslationsResource targetDoc = new TranslationsResource();
        this.propReader.extractTarget(targetDoc, (InputStream)new FileInputStream(transFile));
        return targetDoc;
    }

    @Override
    public void visitTranslationResources(String docName, Resource srcDoc, PushCommand.TranslationResourcesVisitor callback) throws IOException {
        for (LocaleMapping locale : this.getOpts().getLocaleMapList()) {
            String filename = this.docNameToFilename(docName, locale);
            File transFile = new File(this.getOpts().getTransDir(), filename);
            if (!transFile.exists()) continue;
            TranslationsResource targetDoc = this.loadTranslationsResource(srcDoc, transFile);
            callback.visit(locale, targetDoc);
        }
    }
}

