/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.stats;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.stats.ConsoleStatisticsOutput;
import org.zanata.client.commands.stats.ContainerStatisticsCommandOutput;
import org.zanata.client.commands.stats.CsvStatisticsOutput;
import org.zanata.client.commands.stats.GetStatisticsOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.service.StatisticsResource;

public class GetStatisticsCommand
extends ConfigurableCommand<GetStatisticsOptions> {
    private static final Logger log = LoggerFactory.getLogger(GetStatisticsCommand.class);
    private StatisticsResource statsResource = this.getRequestFactory().getStatisticsResource();

    public GetStatisticsCommand(GetStatisticsOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws Exception {
        String[] localeListArg = null;
        if (((GetStatisticsOptions)this.getOpts()).getLocaleMapList() != null) {
            ArrayList<String> localeList = new ArrayList<String>();
            for (LocaleMapping locMapping : ((GetStatisticsOptions)this.getOpts()).getLocaleMapList()) {
                localeList.add(locMapping.getLocale());
            }
            localeListArg = localeList.toArray(new String[0]);
        }
        ContainerTranslationStatistics containerStats = null;
        containerStats = ((GetStatisticsOptions)this.getOpts()).getDocumentId() == null ? this.statsResource.getStatistics(((GetStatisticsOptions)this.getOpts()).getProj(), ((GetStatisticsOptions)this.getOpts()).getProjectVersion(), ((GetStatisticsOptions)this.getOpts()).getIncludeDetails(), ((GetStatisticsOptions)this.getOpts()).getIncludeWordLevelStats(), localeListArg) : this.statsResource.getStatistics(((GetStatisticsOptions)this.getOpts()).getProj(), ((GetStatisticsOptions)this.getOpts()).getProjectVersion(), ((GetStatisticsOptions)this.getOpts()).getDocumentId(), ((GetStatisticsOptions)this.getOpts()).getIncludeWordLevelStats(), localeListArg);
        if (((GetStatisticsOptions)this.getOpts()).getFormat() == null) {
            log.warn("Output format not specified; defaulting to Console output.");
        }
        ContainerStatisticsCommandOutput statsOutput = "csv".equalsIgnoreCase(((GetStatisticsOptions)this.getOpts()).getFormat()) ? new CsvStatisticsOutput() : new ConsoleStatisticsOutput();
        statsOutput.write(containerStats);
    }
}

