/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.glossary.delete;

import java.net.URI;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.glossary.delete.GlossaryDeleteOptions;
import org.zanata.common.LocaleId;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.IGlossaryResource;
import org.zanata.rest.client.ZanataProxyFactory;

public class GlossaryDeleteCommand
extends ConfigurableCommand<GlossaryDeleteOptions> {
    private static final Logger log = LoggerFactory.getLogger(GlossaryDeleteCommand.class);
    private final IGlossaryResource glossaryResource;
    private final URI uri;

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts, ZanataProxyFactory factory, IGlossaryResource glossaryResource, URI uri) {
        super(opts, factory);
        this.glossaryResource = glossaryResource;
        this.uri = uri;
    }

    private GlossaryDeleteCommand(GlossaryDeleteOptions opts, ZanataProxyFactory factory) {
        this(opts, factory, factory.getGlossaryResource(), factory.getGlossaryResourceURI());
    }

    public GlossaryDeleteCommand(GlossaryDeleteOptions opts) {
        this(opts, OptionsUtil.createRequestFactory(opts));
    }

    @Override
    public void run() throws Exception {
        ClientResponse response;
        log.info("Server: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUrl());
        log.info("Username: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getUsername());
        log.info("Locale to delete: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getlang());
        log.info("Delete entire glossary?: {}", (Object)((GlossaryDeleteOptions)this.getOpts()).getAllGlossary());
        if (((GlossaryDeleteOptions)this.getOpts()).getAllGlossary()) {
            response = this.glossaryResource.deleteGlossaries();
        } else if (!StringUtils.isEmpty((String)((GlossaryDeleteOptions)this.getOpts()).getlang())) {
            response = this.glossaryResource.deleteGlossary(new LocaleId(((GlossaryDeleteOptions)this.getOpts()).getlang()));
        } else {
            throw new RuntimeException("Option 'zanata.lang' is required.");
        }
        ClientUtility.checkResult((ClientResponse)response, (URI)this.uri);
    }
}

