/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.config;

import java.io.File;
import java.net.URL;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.HierarchicalINIConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.junit.Assert;
import org.junit.Test;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.config.ZanataConfig;

public class ZanataConfigTest {
    JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ZanataConfig.class});
    Unmarshaller unmarshaller = this.jc.createUnmarshaller();
    Marshaller marshaller = this.jc.createMarshaller();
    File zanataProjectXml = new File(System.getProperty("user.dir"), "target/zanata.xml");
    File zanataUserFile = new File(System.getProperty("user.dir"), "target/zanata.ini");

    public ZanataConfigTest() throws Exception {
        this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
    }

    @Test
    public void testWriteReadProject() throws Exception {
        this.writeProject();
        this.readProject();
    }

    void writeProject() throws Exception {
        ZanataConfig config = new ZanataConfig();
        config.setUrl(new URL("http://example.com"));
        config.setProject("project");
        config.setProjectVersion("version");
        config.getLocales().add(new LocaleMapping("fr", "fr-FR"));
        config.getLocales().add(new LocaleMapping("  zh-CN  "));
        this.marshaller.marshal((Object)config, this.zanataProjectXml);
    }

    void readProject() throws Exception {
        ZanataConfig config = (ZanataConfig)this.unmarshaller.unmarshal(this.zanataProjectXml);
        Assert.assertEquals((Object)new URL("http://example.com"), (Object)config.getUrl());
        Assert.assertEquals((Object)"project", (Object)config.getProject());
        Assert.assertEquals((Object)"version", (Object)config.getProjectVersion());
        LocaleList locales = config.getLocales();
        Assert.assertEquals((long)2L, (long)locales.size());
        Assert.assertEquals((Object)"fr", (Object)locales.get(0).getLocale());
        Assert.assertEquals((Object)"fr-FR", (Object)locales.get(0).getMapFrom());
        Assert.assertEquals((Object)"zh-CN", (Object)locales.get(1).getLocale());
        Assert.assertNull((Object)locales.get(1).getMapFrom());
    }

    @Test
    public void testWriteReadUser() throws Exception {
        this.writeUser();
        this.readUser();
    }

    void writeUser() throws Exception {
        HierarchicalINIConfiguration config = new HierarchicalINIConfiguration(this.zanataUserFile);
        config.setProperty("zanata.url", (Object)new URL("http://zanata.example.com/"));
        config.setProperty("zanata.username", (Object)"admin");
        config.setProperty("zanata.key", (Object)"b6d7044e9ee3b2447c28fb7c50d86d98");
        config.setProperty("zanata.debug", (Object)false);
        config.setProperty("zanata.errors", (Object)true);
        config.save();
    }

    void readUser() throws Exception {
        CompositeConfiguration config = new CompositeConfiguration();
        config.addConfiguration((Configuration)new SystemConfiguration());
        config.addConfiguration((Configuration)new HierarchicalINIConfiguration(this.zanataUserFile));
        String user = config.getString("zanata.username");
        Assert.assertEquals((Object)"admin", (Object)user);
        boolean debug = config.getBoolean("zanata.debug");
        Assert.assertFalse((boolean)debug);
        boolean errors = config.getBoolean("zanata.errors");
        Assert.assertTrue((boolean)errors);
    }
}

