/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.etag;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.keyvalue.MultiKey;
import org.zanata.client.etag.ETagCacheCollection;
import org.zanata.client.etag.ETagCacheEntry;

public class ETagCache {
    private Map<MultiKey, ETagCacheEntry> fileNameIndex = new LinkedHashMap<MultiKey, ETagCacheEntry>();

    public ETagCache() {
    }

    ETagCache(ETagCacheCollection entries) {
        for (ETagCacheEntry entry : entries.getCacheEntries()) {
            this.addEntry(entry);
        }
    }

    public List<ETagCacheEntry> getCacheEntries() {
        return new ArrayList<ETagCacheEntry>(this.fileNameIndex.values());
    }

    public void addEntry(ETagCacheEntry entry) {
        this.fileNameIndex.put(new MultiKey((Object)entry.getLocalFileName(), (Object)entry.getLanguage()), entry);
    }

    public ETagCacheEntry findEntry(String localFileName, String language) {
        return this.fileNameIndex.get(new MultiKey((Object)localFileName, (Object)language));
    }

    public void clear() {
        this.fileNameIndex.clear();
    }

    ETagCacheCollection asETagCacheCollection() {
        ETagCacheCollection col = new ETagCacheCollection();
        col.setCacheEntries(new ArrayList<ETagCacheEntry>(this.fileNameIndex.values()));
        return col;
    }
}

