/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.DummyResponse;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PublicanPushCommand;
import org.zanata.client.commands.PublicanPushOptions;
import org.zanata.client.commands.PublicanPushOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PublicanPushCommandTest {
    @Mock
    ISourceDocResource mockSourceDocResource;
    @Mock
    ITranslatedDocResource mockTranslationResources;

    @Before
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void publicanPushPot() throws Exception {
        this.publicanPush(false, false);
    }

    @Test
    public void publicanPushPotAndPo() throws Exception {
        this.publicanPush(true, false);
    }

    @Test
    public void publicanPushPotAndPoWithLocaleMapping() throws Exception {
        this.publicanPush(true, true);
    }

    private void publicanPush(boolean importPo, boolean mapLocale) throws Exception {
        PublicanPushOptionsImpl opts = new PublicanPushOptionsImpl();
        opts.setInteractiveMode(false);
        String projectSlug = "project";
        opts.setProj(projectSlug);
        String versionSlug = "1.0";
        opts.setProjectVersion(versionSlug);
        opts.setSrcDir(new File("src/test/resources/test1"));
        opts.setImportPo(importPo);
        OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
        if (mapLocale) {
            LocaleList locales = new LocaleList();
            locales.add(new LocaleMapping("ja", "ja-JP"));
            opts.setLocaleMapList(locales);
        }
        ArrayList<ResourceMeta> resourceMetaList = new ArrayList<ResourceMeta>();
        resourceMetaList.add(new ResourceMeta("obsolete"));
        resourceMetaList.add(new ResourceMeta("RPM"));
        Mockito.when((Object)this.mockSourceDocResource.get(null)).thenReturn(new DummyResponse(Response.Status.OK, resourceMetaList));
        DummyResponse<Object> okResponse = new DummyResponse<Object>(Response.Status.OK, null);
        Mockito.when((Object)this.mockSourceDocResource.deleteResource("obsolete")).thenReturn(okResponse);
        StringSet extensionSet = new StringSet("gettext;comment");
        Mockito.when((Object)this.mockSourceDocResource.putResource((String)Matchers.eq((Object)"RPM"), (Resource)Matchers.isNotNull(), (Set)Matchers.eq((Object)extensionSet), Matchers.eq((boolean)true))).thenReturn(okResponse);
        Mockito.when((Object)this.mockSourceDocResource.putResource((String)Matchers.eq((Object)"sub,RPM"), (Resource)Matchers.isNotNull(), (Set)Matchers.eq((Object)extensionSet), Matchers.eq((boolean)true))).thenReturn(okResponse);
        if (importPo) {
            LocaleId expectedLocale = mapLocale ? new LocaleId("ja") : new LocaleId("ja-JP");
            Mockito.when((Object)this.mockTranslationResources.putTranslations((String)Matchers.eq((Object)"RPM"), (LocaleId)Matchers.eq((Object)expectedLocale), (TranslationsResource)Matchers.isNotNull(), (Set)Matchers.eq((Object)extensionSet), (String)Matchers.eq((Object)"auto"))).thenReturn(okResponse);
        }
        ZanataProxyFactory mockRequestFactory = (ZanataProxyFactory)Mockito.mock(ZanataProxyFactory.class);
        PublicanPushCommand cmd = new PublicanPushCommand((PublicanPushOptions)opts, mockRequestFactory, this.mockSourceDocResource, this.mockTranslationResources, new URI("http://example.com/"));
        cmd.run();
    }
}

