/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.PutProjectOptions;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.IProjectResource;
import org.zanata.rest.dto.Project;

public class PutProjectCommand
extends ConfigurableCommand<PutProjectOptions> {
    private static final Logger log = LoggerFactory.getLogger(PutProjectCommand.class);

    public PutProjectCommand(PutProjectOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws JAXBException, URISyntaxException, IOException, Exception {
        Project project = new Project();
        project.setId(((PutProjectOptions)this.getOpts()).getProjectSlug());
        project.setName(((PutProjectOptions)this.getOpts()).getProjectName());
        project.setDescription(((PutProjectOptions)this.getOpts()).getProjectDesc());
        project.setSourceViewURL(((PutProjectOptions)this.getOpts()).getSourceViewUrl());
        project.setSourceCheckoutURL(((PutProjectOptions)this.getOpts()).getSourceCheckoutUrl());
        if (((PutProjectOptions)this.getOpts()).getDefaultProjectType() == null || ((PutProjectOptions)this.getOpts()).getDefaultProjectType().isEmpty()) {
            throw new Exception("Default project type must not be null or empty.");
        }
        project.setDefaultType(((PutProjectOptions)this.getOpts()).getDefaultProjectType());
        log.debug("{}", (Object)project);
        IProjectResource projResource = this.getRequestFactory().getProject(((PutProjectOptions)this.getOpts()).getProjectSlug());
        URI uri = this.getRequestFactory().getProjectURI(((PutProjectOptions)this.getOpts()).getProjectSlug());
        ClientResponse response = projResource.put(project);
        ClientUtility.checkResult((ClientResponse)response, (URI)uri);
    }
}

