/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.gettext;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.AndFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.util.PathUtil;

public class PublicanUtil {
    private static final Logger log = LoggerFactory.getLogger(PublicanUtil.class);

    private PublicanUtil() {
    }

    public static String[] findPotFiles(File potDir, AndFileFilter fileFilter) throws IOException {
        SuffixFileFilter extensionFilter = new SuffixFileFilter(".pot");
        fileFilter.addFileFilter((IOFileFilter)extensionFilter);
        Collection files = FileUtils.listFiles((File)potDir, (IOFileFilter)fileFilter, (IOFileFilter)TrueFileFilter.TRUE);
        String[] potFiles = new String[files.size()];
        Iterator iter = files.iterator();
        for (int i = 0; i < potFiles.length; ++i) {
            String relativePath;
            File potFile = (File)iter.next();
            potFiles[i] = relativePath = PathUtil.getSubPath((File)potFile, (File)potDir);
        }
        return potFiles;
    }

    public static File[] findLocaleDirs(File srcDir) {
        File[] localeDirs = srcDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() && !f.getName().equals("pot");
            }
        });
        return localeDirs;
    }

    public static List<LocaleMapping> findLocales(File srcDir) {
        File[] localeDirs = PublicanUtil.findLocaleDirs(srcDir);
        ArrayList<LocaleMapping> locales = new ArrayList<LocaleMapping>();
        for (File dir : localeDirs) {
            locales.add(new LocaleMapping(dir.getName()));
        }
        return locales;
    }

    public static List<LocaleMapping> findLocales(File srcDir, LocaleList locales) {
        ArrayList<LocaleMapping> localeDirs = new ArrayList<LocaleMapping>();
        for (LocaleMapping loc : locales) {
            File localeDir = new File(srcDir, loc.getLocalLocale());
            if (localeDir.isDirectory()) {
                localeDirs.add(loc);
                continue;
            }
            log.warn("configured locale {} not found; directory {} does not exist", (Object)loc.getLocale(), (Object)loc.getLocalLocale());
        }
        return localeDirs;
    }
}

