/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import org.zanata.adapter.xliff.XliffWriter;
import org.zanata.client.commands.pull.AbstractPullStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class XliffStrategy
extends AbstractPullStrategy {
    StringSet extensions = new StringSet("comment");

    protected XliffStrategy(PullOptions opts) {
        super(opts);
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return true;
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        XliffWriter.write((File)this.getOpts().getSrcDir(), (Resource)doc, (String)"en-US");
    }

    @Override
    public File getTransFileToWrite(String docName, LocaleMapping localeMapping) {
        return new File(this.getOpts().getTransDir(), docName + "_" + localeMapping.getLocalLocale().replace('-', '_') + ".xml");
    }

    @Override
    public FileDetails writeTransFile(Resource doc, String docName, LocaleMapping localeMapping, TranslationsResource targetDoc) throws IOException {
        XliffWriter.write((File)this.getOpts().getTransDir(), (Resource)doc, (String)localeMapping.getLocalLocale(), (TranslationsResource)targetDoc, (boolean)this.getOpts().getCreateSkeletons());
        return null;
    }
}

