/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.zanata.client.commands.push.AbstractCommonPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;

public abstract class AbstractPushStrategy
extends AbstractCommonPushStrategy<PushOptions> {
    private StringSet extensions;
    private String fileExtension;

    public abstract Set<String> findDocNames(File var1, List<String> var2, List<String> var3, boolean var4, boolean var5, boolean var6) throws IOException;

    public abstract Resource loadSrcDoc(File var1, String var2) throws IOException;

    public abstract void visitTranslationResources(String var1, Resource var2, PushCommand.TranslationResourcesVisitor var3) throws IOException;

    public AbstractPushStrategy(StringSet extensions, String fileExtension) {
        this.extensions = extensions;
        this.fileExtension = fileExtension;
    }

    public boolean isTransOnly() {
        return false;
    }

    public String[] getSrcFiles(File srcDir, List<String> includes, List<String> excludes, boolean excludeLocaleFilenames, boolean useDefaultExclude, boolean isCaseSensitive) {
        if (excludeLocaleFilenames) {
            this.addExcludesForLocaleFilenames(excludes);
        }
        return this.getSrcFiles(srcDir, includes, excludes, Collections.singletonList(this.fileExtension), useDefaultExclude, isCaseSensitive);
    }

    private void addExcludesForLocaleFilenames(List<String> excludes) {
        String sourceLang = new LocaleId(this.getOpts().getSourceLang()).toJavaName();
        for (LocaleMapping locMap : this.getOpts().getLocaleMapList()) {
            String loc = locMap.getJavaLocale();
            if (sourceLang.equals(loc)) continue;
            excludes.add("**/*_" + loc + this.fileExtension);
        }
    }

    protected String docNameToFilename(String docName) {
        return docName + this.fileExtension;
    }

    protected String docNameToFilename(String docName, LocaleMapping locale) {
        return docName + "_" + locale.getJavaLocale() + this.fileExtension;
    }

    public StringSet getExtensions() {
        return this.extensions;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void init() {
    }
}

