/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.util.List;
import org.apache.tools.ant.DirectoryScanner;
import org.zanata.client.commands.push.PushOptions;

public abstract class AbstractCommonPushStrategy<O extends PushOptions> {
    private O opts;

    public O getOpts() {
        return this.opts;
    }

    public void setPushOptions(O opts) {
        this.opts = opts;
    }

    public String[] getSrcFiles(File srcDir, List<String> includes, List<String> excludes, List<String> fileExtensions, boolean useDefaultExcludes, boolean isCaseSensitive) {
        if (includes.isEmpty()) {
            for (String fileExtension : fileExtensions) {
                includes.add("**/*" + fileExtension);
            }
        }
        DirectoryScanner dirScanner = new DirectoryScanner();
        if (useDefaultExcludes) {
            dirScanner.addDefaultExcludes();
        }
        dirScanner.setBasedir(srcDir);
        dirScanner.setCaseSensitive(isCaseSensitive);
        dirScanner.setExcludes(excludes.toArray(new String[excludes.size()]));
        dirScanner.setIncludes(includes.toArray(new String[includes.size()]));
        dirScanner.scan();
        String[] includedFiles = dirScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = includedFiles[i].replace(File.separator, "/");
        }
        return includedFiles;
    }
}

