/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.OutputStream;
import java.io.PrintStream;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.kohsuke.args4j.CmdLineParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.AppAbortStrategy;
import org.zanata.client.commands.BasicOptions;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.ZanataCommand;

public class ArgsUtil {
    private static final Logger log = LoggerFactory.getLogger(ArgsUtil.class);
    private final AppAbortStrategy abortStrategy;
    private final BasicOptions opts;
    private final CmdLineParser parser;

    public ArgsUtil(AppAbortStrategy strategy, BasicOptions opts) {
        this.abortStrategy = strategy;
        this.opts = opts;
        this.parser = new CmdLineParser((Object)opts);
        try {
            this.parser.setUsageWidth(Integer.parseInt(System.getenv("COLUMNS")));
        }
        catch (Exception e) {
            this.parser.setUsageWidth(120);
        }
    }

    public void runCommand() {
        ArgsUtil.setLogLevels(this.opts);
        try {
            if (this.opts instanceof ConfigurableOptions) {
                OptionsUtil.applyConfigFiles((ConfigurableOptions)this.opts);
            }
            ArgsUtil.setLogLevels(this.opts);
            if (this.opts.getErrors()) {
                log.info("Error stacktraces are turned on.");
            }
            ZanataCommand cmd = this.opts.initCommand();
            cmd.run();
        }
        catch (Exception e) {
            ArgsUtil.handleException(e, this.opts.getErrors(), this.abortStrategy);
        }
    }

    private static void setLogLevels(BasicOptions opts) {
        if (opts.getDebug()) {
            ArgsUtil.enableDebugLogging(opts);
        } else if (opts.getQuiet()) {
            ArgsUtil.enableQuietLogging(opts);
        }
    }

    private static void enableDebugLogging(BasicOptions opts) {
        ArgsUtil.setRootLoggerLevel("DEBUG", opts);
    }

    private static void enableQuietLogging(BasicOptions opts) {
        ArgsUtil.setRootLoggerLevel("ERROR", opts);
    }

    private static void setRootLoggerLevel(String level, BasicOptions opts) {
        block2: {
            try {
                LogManager.getRootLogger().setLevel(Level.toLevel((String)level));
            }
            catch (Exception e) {
                System.err.println("Unable to change logging level: " + e.toString());
                if (!opts.getErrors()) break block2;
                e.printStackTrace();
            }
        }
    }

    public void printHelp(PrintStream output, String clientName) {
        output.print("Usage: " + clientName + " " + this.opts.getCommandName());
        this.parser.printSingleLineUsage((OutputStream)output);
        output.println();
        output.println();
        output.println(this.opts.getCommandDescription());
        output.println();
        this.parser.printUsage((OutputStream)output);
    }

    public static void handleException(Exception e, boolean outputErrors, AppAbortStrategy abortStrategy) {
        if (outputErrors) {
            log.error("Execution failed: ", (Throwable)e);
        } else {
            log.error("Execution failed: " + e.getMessage());
            log.error("Use -e/--errors for full stack trace (or when reporting bugs)");
        }
        abortStrategy.abort(e);
    }
}

