/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.xml.sax.InputSource;
import org.zanata.adapter.po.PoReader2;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public abstract class AbstractGettextPushStrategy
extends AbstractPushStrategy {
    private PoReader2 poReader;

    public AbstractGettextPushStrategy() {
        super(new StringSet("comment;gettext"), ".pot");
    }

    @Override
    public Set<String> findDocNames(File srcDir, List<String> includes, List<String> excludes, boolean useDefaultExclude, boolean caseSensitive, boolean excludeLocaleFilenames) throws IOException {
        String[] srcFiles;
        HashSet<String> localDocNames = new HashSet<String>();
        for (String potName : srcFiles = this.getSrcFiles(srcDir, includes, excludes, false, useDefaultExclude, caseSensitive)) {
            String docName = FilenameUtils.removeExtension((String)potName);
            localDocNames.add(docName);
        }
        return localDocNames;
    }

    abstract Collection<LocaleMapping> findLocales();

    abstract File getTransFile(LocaleMapping var1, String var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws IOException {
        File srcFile = new File(sourceDir, docName + this.getFileExtension());
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(srcFile));
        try {
            InputSource potInputSource = new InputSource(bis);
            potInputSource.setEncoding("utf8");
            Resource resource = this.getPoReader().extractTemplate(potInputSource, new LocaleId(this.getOpts().getSourceLang()), docName);
            return resource;
        }
        finally {
            bis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitTranslationResources(String docName, Resource srcDoc, PushCommand.TranslationResourcesVisitor callback) throws IOException {
        for (LocaleMapping locale : this.findLocales()) {
            File transFile = this.getTransFile(locale, docName);
            if (!transFile.canRead()) continue;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(transFile));
            try {
                InputSource inputSource = new InputSource(bis);
                inputSource.setEncoding("utf8");
                TranslationsResource targetDoc = this.getPoReader().extractTarget(inputSource);
                callback.visit(locale, targetDoc);
            }
            finally {
                bis.close();
            }
        }
    }

    protected PoReader2 getPoReader() {
        if (this.poReader == null) {
            this.poReader = new PoReader2();
        }
        return this.poReader;
    }
}

