/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.zanata.adapter.xliff.XliffReader;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;

public class XliffStrategy
extends AbstractPushStrategy {
    XliffReader reader = new XliffReader();
    Set<String> sourceFiles;

    public XliffStrategy() {
        super(new StringSet("comment"), ".xml");
    }

    @Override
    public Set<String> findDocNames(File srcDir, List<String> includes, List<String> excludes, boolean useDefaultExclude, boolean caseSensitive, boolean excludeLocaleFilenames) throws IOException {
        String[] files;
        this.sourceFiles = new HashSet<String>();
        HashSet<String> localDocNames = new HashSet<String>();
        for (String relativeFilePath : files = this.getSrcFiles(srcDir, includes, excludes, excludeLocaleFilenames, useDefaultExclude, caseSensitive)) {
            this.sourceFiles.add(relativeFilePath);
            String baseName = FilenameUtils.removeExtension((String)relativeFilePath);
            baseName = this.trimLocaleFromFile(baseName);
            localDocNames.add(baseName);
        }
        return localDocNames;
    }

    private String trimLocaleFromFile(String fileName) {
        if (fileName.contains("_")) {
            String loc = new LocaleId(this.getOpts().getSourceLang()).toJavaName();
            if (StringUtils.containsIgnoreCase((String)fileName, (String)("_" + loc))) {
                fileName = fileName.replaceAll("_" + loc, "");
            }
        }
        return fileName;
    }

    @Override
    public Resource loadSrcDoc(File sourceDir, String docName) throws FileNotFoundException {
        File srcFile = null;
        for (String file : this.sourceFiles) {
            if (!file.startsWith(docName) || !file.endsWith(this.getFileExtension())) continue;
            srcFile = new File(sourceDir, file);
            break;
        }
        return this.reader.extractTemplate(srcFile, new LocaleId(this.getOpts().getSourceLang()), docName, this.getOpts().getValidate());
    }

    @Override
    public void visitTranslationResources(String docName, Resource srcDoc, PushCommand.TranslationResourcesVisitor visitor) throws FileNotFoundException {
        for (LocaleMapping locale : this.getOpts().getLocaleMapList()) {
            String filename = this.docNameToFilename(docName, locale);
            File transFile = new File(this.getOpts().getTransDir(), filename);
            if (!transFile.exists()) continue;
            TranslationsResource targetDoc = this.reader.extractTarget(transFile);
            visitor.visit(locale, targetDoc);
        }
    }
}

