/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import org.kohsuke.args4j.Option;
import org.zanata.client.commands.AbstractPushPullOptionsImpl;
import org.zanata.client.commands.BooleanValueHandler;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.ZanataCommand;
import org.zanata.client.commands.pull.PullCommand;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.RawPullCommand;

public class PullOptionsImpl
extends AbstractPushPullOptionsImpl<PullOptions>
implements PullOptions {
    private static final String DEFAULT_PULL_TYPE = "trans";
    private static final boolean DEFAULT_CREATE_SKELETONS = false;
    private static final boolean DEFAULT_ENCODE_TABS = true;
    private static final boolean DEFAULT_INCLUDE_FUZZY = false;
    private static final boolean DEFAULT_USE_CACHE = true;
    private static final boolean DEFAULT_PURGE_CACHE = false;
    private static final boolean DEFAULT_CONTINUE_AFTER_ERROR = false;
    private String pullType = "trans";
    private boolean createSkeletons = false;
    private boolean encodeTabs = true;
    private boolean includeFuzzy = false;
    private boolean useCache = true;
    private boolean purgeCache = false;
    private boolean continueAfterError = false;

    @Override
    public ZanataCommand initCommand() {
        if ("file".equalsIgnoreCase(this.getProjectType())) {
            return new RawPullCommand(this);
        }
        return new PullCommand(this);
    }

    @Override
    public String getCommandName() {
        return "pull";
    }

    @Override
    public String getCommandDescription() {
        return "Pull translated text from Zanata.";
    }

    @Option(aliases={"-l"}, name="--locales", metaVar="LOCALE1,LOCALE2", usage="Locales to pull from the server.\nBy default all locales in zanata.xml will be pulled.")
    public void setLocales(String locales) {
        this.locales = locales.split(",");
    }

    @Override
    public PushPullType getPullType() {
        return PushPullType.fromString(this.pullType);
    }

    @Option(name="--pull-type", metaVar="TYPE", required=false, usage="Type of pull to perform from the server: \"source\" pulls source documents only.\n\"trans\" (default) pulls translation documents only.\n\"both\" pulls both source and translation documents.")
    public void setPullType(String pullType) {
        this.pullType = pullType;
    }

    @Override
    public boolean getCreateSkeletons() {
        return this.createSkeletons;
    }

    @Option(name="--create-skeletons", usage="Create skeleton entries for strings/files which have not been translated yet. Skeletons are not created by default.")
    public void setCreateSkeletons(boolean createSkeletons) {
        this.createSkeletons = createSkeletons;
    }

    @Override
    public boolean getEncodeTabs() {
        return this.encodeTabs;
    }

    @Option(name="--encode-tabs", handler=BooleanValueHandler.class, usage="Whether tabs should be encoded as \\t (true, default) or left as tabs (false).")
    public void setEncodeTabs(boolean encodeTabs) {
        this.encodeTabs = encodeTabs;
    }

    @Override
    public boolean getIncludeFuzzy() {
        return this.includeFuzzy;
    }

    @Option(name="--include-fuzzy", usage="[project type 'file' only] Whether to include fuzzy translations in translation files. If this option is false (default), source text will be used for any string that does not have an approved translation.")
    public void setIncludeFuzzy(boolean includeFuzzy) {
        this.includeFuzzy = includeFuzzy;
    }

    @Override
    public boolean getPurgeCache() {
        return this.purgeCache;
    }

    @Override
    public boolean getUseCache() {
        return this.useCache;
    }

    @Option(name="--continue-after-error", aliases={"-c"}, usage="When there is an error, whether try to workaround it and continue to next text flow or fail the process.i.e. when encounter a mismatch plural form, it will try to use singular form.\nNote: This option may not work on all circumstances.")
    public void setContinueAfterError(boolean continueAfterError) {
        this.continueAfterError = continueAfterError;
    }

    @Override
    public boolean isContinueAfterError() {
        return this.continueAfterError;
    }
}

