/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.zanata.client.commands.pull.AbstractPullStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.StringSet;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.PathUtil;

public class XmlStrategy
extends AbstractPullStrategy {
    private JAXBContext jaxbContext;
    private Marshaller marshaller;
    StringSet extensions = new StringSet("comment;gettext");

    protected XmlStrategy(PullOptions opts) {
        super(opts);
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Resource.class, TranslationsResource.class});
            this.marshaller = this.jaxbContext.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean needsDocToWriteTrans() {
        return false;
    }

    private String docNameToFilename(String docName) {
        return docName + ".xml";
    }

    private String docNameToFilename(String docName, LocaleMapping locale) {
        return docName + "_" + locale.getJavaLocale() + ".xml";
    }

    @Override
    public void writeSrcFile(Resource doc) throws IOException {
        try {
            String filename = this.docNameToFilename(doc.getName());
            File srcFile = new File(this.getOpts().getSrcDir(), filename);
            PathUtil.makeParents((File)srcFile);
            this.marshaller.marshal((Object)doc, srcFile);
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public File getTransFileToWrite(String docName, LocaleMapping localeMapping) {
        String filename = this.docNameToFilename(docName, localeMapping);
        File transFile = new File(this.getOpts().getTransDir(), filename);
        return transFile;
    }

    @Override
    public FileDetails writeTransFile(Resource doc, String docName, LocaleMapping locale, TranslationsResource targetDoc) throws IOException {
        try {
            File transFile = this.getTransFileToWrite(docName, locale);
            PathUtil.makeParents((File)transFile);
            this.marshaller.marshal((Object)targetDoc, transFile);
            return null;
        }
        catch (JAXBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public StringSet getExtensions() {
        return this.extensions;
    }
}

