/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.gettext.PublicanUtil;
import org.zanata.client.commands.push.AbstractGettextPushStrategy;
import org.zanata.client.config.LocaleMapping;

public class GettextDirStrategy
extends AbstractGettextPushStrategy {
    private static final Logger log = LoggerFactory.getLogger(GettextDirStrategy.class);

    List<LocaleMapping> findLocales() {
        List<LocaleMapping> locales;
        if (this.getOpts().getLocaleMapList() != null) {
            locales = PublicanUtil.findLocales(this.getOpts().getTransDir(), this.getOpts().getLocaleMapList());
            if (locales.size() == 0) {
                log.warn("'pushType' is set to '" + (Object)((Object)this.getOpts().getPushType()) + "', but none of the configured locale " + "directories was found (check zanata.xml)");
            }
        } else {
            locales = PublicanUtil.findLocales(this.getOpts().getTransDir());
            if (locales.size() == 0) {
                log.warn("'pushType' is set to '\" + getOpts().getPushType() + \"', but no locale directories were found");
            } else {
                log.info("'pushType' is set to '\" + getOpts().getPushType() + \"', but no locales specified in configuration: importing " + locales.size() + " directories");
            }
        }
        return locales;
    }

    @Override
    File getTransFile(LocaleMapping locale, String docName) {
        File localeDir = new File(this.getOpts().getTransDir(), locale.getLocalLocale());
        File transFile = new File(localeDir, docName + ".po");
        return transFile;
    }
}

