/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.pull.GettextDirStrategy;
import org.zanata.client.commands.pull.GettextPullStrategy;
import org.zanata.client.commands.pull.OfflinePoStrategy;
import org.zanata.client.commands.pull.PropertiesStrategy;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.commands.pull.PullStrategy;
import org.zanata.client.commands.pull.UTF8PropertiesStrategy;
import org.zanata.client.commands.pull.XliffStrategy;
import org.zanata.client.commands.pull.XmlStrategy;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.etag.ETagCacheEntry;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.common.LocaleId;
import org.zanata.common.io.FileDetails;
import org.zanata.rest.RestUtil;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.HashUtil;

public class PullCommand
extends PushPullCommand<PullOptions> {
    private static final Logger log = LoggerFactory.getLogger(PullCommand.class);
    private static final Map<String, Class<? extends PullStrategy>> strategies = new HashMap<String, Class<? extends PullStrategy>>();

    public PullCommand(PullOptions opts) {
        super(opts);
        strategies.put("utf8properties", UTF8PropertiesStrategy.class);
        strategies.put("properties", PropertiesStrategy.class);
        strategies.put("gettext", GettextPullStrategy.class);
        strategies.put("podir", GettextDirStrategy.class);
        strategies.put("xliff", XliffStrategy.class);
        strategies.put("xml", XmlStrategy.class);
        strategies.put("offlinepo", OfflinePoStrategy.class);
    }

    public PullCommand(PullOptions opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory, sourceDocResource, translationResources, uri);
        strategies.put("utf8properties", UTF8PropertiesStrategy.class);
        strategies.put("properties", PropertiesStrategy.class);
        strategies.put("gettext", GettextPullStrategy.class);
        strategies.put("podir", GettextDirStrategy.class);
        strategies.put("xliff", XliffStrategy.class);
        strategies.put("xml", XmlStrategy.class);
        strategies.put("offlinepo", OfflinePoStrategy.class);
    }

    private PullStrategy createStrategy(String strategyType) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Class<? extends PullStrategy> clazz = strategies.get(strategyType);
        if (clazz == null) {
            throw new RuntimeException("unknown project type: " + ((PullOptions)this.getOpts()).getProjectType());
        }
        Constructor<? extends PullStrategy> ctor = clazz.getDeclaredConstructor(PullOptions.class);
        assert (ctor != null) : "strategy must have constructor which accepts PullOptions";
        return ctor.newInstance(this.getOpts());
    }

    private void logOptions() {
        PullCommand.logOptions(log, (PullOptions)this.getOpts());
        log.info("Create skeletons for untranslated messages/files: {}", (Object)((PullOptions)this.getOpts()).getCreateSkeletons());
        if (((PullOptions)this.getOpts()).getFromDoc() != null) {
            log.info("From document: {}", (Object)((PullOptions)this.getOpts()).getFromDoc());
        }
        if (((PullOptions)this.getOpts()).isDryRun()) {
            log.info("DRY RUN: no permanent changes will be made");
        }
    }

    public static void logOptions(Logger logger, PullOptions opts) {
        logger.info("Server: {}", (Object)opts.getUrl());
        logger.info("Project: {}", (Object)opts.getProj());
        logger.info("Version: {}", (Object)opts.getProjectVersion());
        logger.info("Username: {}", (Object)opts.getUsername());
        logger.info("Project type: {}", (Object)opts.getProjectType());
        logger.info("Enable modules: {}", (Object)opts.getEnableModules());
        logger.info("Using ETag cache: {}", (Object)opts.getUseCache());
        logger.info("Purging ETag cache beforehand: {}", (Object)opts.getPurgeCache());
        if (opts.getEnableModules()) {
            logger.info("Current Module: {}", (Object)opts.getCurrentModule());
            if (opts.isRootModule()) {
                logger.info("Root module: YES");
                if (logger.isDebugEnabled()) {
                    logger.debug("Modules: {}", (Object)StringUtils.join(opts.getAllModules(), (String)", "));
                }
            }
        }
        logger.info("Locales to pull: {}", (Object)opts.getLocaleMapList());
        logger.info("Encode tab as \\t: {}", (Object)opts.getEncodeTabs());
        logger.info("Current directory: {}", (Object)System.getProperty("user.dir"));
        if (opts.getPullType() == PushPullType.Source) {
            logger.info("Pulling source documents only");
            logger.info("Source-language directory (originals): {}", (Object)opts.getSrcDir());
        } else if (opts.getPullType() == PushPullType.Trans) {
            logger.info("Pulling target documents (translations) only");
            logger.info("Target-language base directory (translations): {}", (Object)opts.getTransDir());
        } else {
            logger.info("Pulling source and target (translation) documents");
            logger.info("Source-language directory (originals): {}", (Object)opts.getSrcDir());
            logger.info("Target-language base directory (translations): {}", (Object)opts.getTransDir());
        }
    }

    @Override
    public void run() throws Exception {
        boolean pullTarget;
        this.logOptions();
        LocaleList locales = ((PullOptions)this.getOpts()).getLocaleMapList();
        if (locales == null && ((PullOptions)this.getOpts()).getPullType() != PushPullType.Source) {
            throw new ConfigException("no locales specified");
        }
        PullStrategy strat = this.createStrategy(((PullOptions)this.getOpts()).getProjectType());
        if (strat.isTransOnly() && ((PullOptions)this.getOpts()).getPullType() == PushPullType.Source) {
            log.error("You are trying to pull source only, but source is not available for this project type.\n");
            log.info("Nothing to do. Aborting.\n");
            return;
        }
        List<String> unsortedDocNamesForModule = this.getQualifiedDocNamesForCurrentModuleFromServer();
        TreeSet<String> docNamesForModule = new TreeSet<String>(unsortedDocNamesForModule);
        SortedSet<String> docsToPull = docNamesForModule;
        if (((PullOptions)this.getOpts()).getFromDoc() != null) {
            if (((PullOptions)this.getOpts()).getEnableModules()) {
                if (this.belongsToCurrentModule(((PullOptions)this.getOpts()).getFromDoc())) {
                    docsToPull = this.getDocsAfterFromDoc(((PullOptions)this.getOpts()).getFromDoc(), docsToPull);
                }
            } else {
                docsToPull = this.getDocsAfterFromDoc(((PullOptions)this.getOpts()).getFromDoc(), docsToPull);
            }
        }
        if (docNamesForModule.isEmpty()) {
            log.info("No documents in remote module: {}; nothing to do", (Object)((PullOptions)this.getOpts()).getCurrentModule());
            return;
        }
        log.info("Pulling {} of {} docs for this module from the server", (Object)docsToPull.size(), (Object)docNamesForModule.size());
        log.debug("Doc names: {}", docsToPull);
        PushPullType pullType = ((PullOptions)this.getOpts()).getPullType();
        boolean pullSrc = pullType == PushPullType.Both || pullType == PushPullType.Source;
        boolean bl = pullTarget = pullType == PushPullType.Both || pullType == PushPullType.Trans;
        if (pullSrc && strat.isTransOnly()) {
            log.warn("Source is not available for this project type. Source will not be pulled.\n");
            pullSrc = false;
        }
        if (pullSrc) {
            log.warn("Pull Type set to '" + (Object)((Object)pullType) + "': existing source-language files may be overwritten/deleted");
            this.confirmWithUser("This will overwrite/delete any existing documents and translations in the above directories.\n");
        } else {
            this.confirmWithUser("This will overwrite/delete any existing translations in the above directory.\n");
        }
        if (((PullOptions)this.getOpts()).getPurgeCache()) {
            this.eTagCache.clear();
        }
        for (String qualifiedDocName : docsToPull) {
            try {
                Resource doc = null;
                String localDocName = this.unqualifiedDocName(qualifiedDocName);
                String docUri = RestUtil.convertToDocumentURIId((String)qualifiedDocName);
                boolean createSkeletons = ((PullOptions)this.getOpts()).getCreateSkeletons();
                if (strat.needsDocToWriteTrans() || pullSrc || createSkeletons) {
                    ClientResponse resourceResponse = this.sourceDocResource.getResource(docUri, (Set)strat.getExtensions());
                    ClientUtility.checkResult((ClientResponse)resourceResponse, (URI)this.uri);
                    doc = (Resource)resourceResponse.getEntity();
                    doc.setName(localDocName);
                }
                if (pullSrc) {
                    this.writeSrcDoc(strat, doc);
                }
                if (!pullTarget) continue;
                for (LocaleMapping locMapping : locales) {
                    TranslationsResource targetDoc;
                    ClientResponse transResponse;
                    LocaleId locale = new LocaleId(locMapping.getLocale());
                    String eTag = null;
                    File transFile = strat.getTransFileToWrite(localDocName, locMapping);
                    ETagCacheEntry eTagCacheEntry = this.eTagCache.findEntry(localDocName, locale.getId());
                    if (((PullOptions)this.getOpts()).getUseCache() && eTagCacheEntry != null && transFile.exists() && Long.toString(transFile.lastModified()).equals(eTagCacheEntry.getLocalFileTime())) {
                        eTag = eTagCacheEntry.getServerETag();
                    }
                    if ((transResponse = this.translationResources.getTranslations(docUri, locale, (Set)strat.getExtensions(), createSkeletons, eTag)).getResponseStatus() == Response.Status.NOT_FOUND) {
                        targetDoc = null;
                        if (!createSkeletons) {
                            log.info("No translations found in locale {} for document {}", (Object)locale, (Object)localDocName);
                            transResponse.releaseConnection();
                            continue;
                        }
                    } else if (transResponse.getResponseStatus() == Response.Status.NOT_MODIFIED) {
                        targetDoc = null;
                        log.info("No changes in translations for locale {} and document {}", (Object)locale, (Object)localDocName);
                        String fileChecksum = HashUtil.getMD5Checksum((File)transFile);
                        if (!fileChecksum.equals(eTagCacheEntry.getLocalFileMD5())) {
                            transResponse = this.translationResources.getTranslations(docUri, locale, (Set)strat.getExtensions(), createSkeletons, null);
                            ClientUtility.checkResult((ClientResponse)transResponse, (URI)this.uri);
                            targetDoc = (TranslationsResource)transResponse.getEntity();
                        }
                    } else {
                        ClientUtility.checkResult((ClientResponse)transResponse, (URI)this.uri);
                        targetDoc = (TranslationsResource)transResponse.getEntity();
                    }
                    if (targetDoc == null && !createSkeletons) continue;
                    this.writeTargetDoc(strat, localDocName, locMapping, doc, targetDoc, (String)transResponse.getResponseHeaders().getFirst((Object)"ETag"));
                }
                super.storeETagCache();
            }
            catch (RuntimeException e) {
                String message = "Operation failed.\n\n    To retry from the last document, please set the following option(s):\n\n        ";
                if (((PullOptions)this.getOpts()).getEnableModules()) {
                    message = message + "--resume-from " + ((PullOptions)this.getOpts()).getCurrentModule(true) + " ";
                }
                message = message + ((PullOptions)this.getOpts()).buildFromDocArgument(qualifiedDocName) + "\n\n.";
                throw new RuntimeException(message, e);
            }
        }
    }

    private SortedSet<String> getDocsAfterFromDoc(String fromDoc, SortedSet<String> docNames) {
        if (!docNames.contains(fromDoc)) {
            throw new RuntimeException("Document with id " + fromDoc + " not found, unable to start pull from unknown document. Aborting.");
        }
        SortedSet<String> docsToPull = docNames.tailSet(fromDoc);
        int numSkippedDocs = docNames.size() - docsToPull.size();
        log.info("Skipping {} document(s) before {}.", (Object)numSkippedDocs, (Object)fromDoc);
        return docsToPull;
    }

    private void writeSrcDoc(PullStrategy strat, Resource doc) throws IOException {
        if (!((PullOptions)this.getOpts()).isDryRun()) {
            log.info("Writing source file for document {}", (Object)doc.getName());
            strat.writeSrcFile(doc);
        } else {
            log.info("Writing source file for document {} (skipped due to dry run)", (Object)doc.getName());
        }
    }

    private void writeTargetDoc(PullStrategy strat, String localDocName, LocaleMapping locMapping, Resource docWithLocalName, TranslationsResource targetDoc, String serverETag) throws IOException {
        if (!((PullOptions)this.getOpts()).isDryRun()) {
            log.info("Writing translation file in locale {} for document {}", (Object)locMapping.getLocalLocale(), (Object)localDocName);
            FileDetails fileDetails = strat.writeTransFile(docWithLocalName, localDocName, locMapping, targetDoc);
            if (((PullOptions)this.getOpts()).getUseCache() && fileDetails != null) {
                this.eTagCache.addEntry(new ETagCacheEntry(localDocName, locMapping.getLocale(), Long.toString(fileDetails.getFile().lastModified()), fileDetails.getMd5(), serverETag));
            }
        } else {
            log.info("Writing translation file in locale {} for document {} (skipped due to dry run)", (Object)locMapping.getLocalLocale(), (Object)localDocName);
        }
    }
}

