/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.config;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.zanata.client.config.LocaleMapping;

@XmlRootElement(name="locales")
@XmlType(name="localesType")
public class LocaleList
implements List<LocaleMapping>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<LocaleMapping> locales = new ArrayList<LocaleMapping>();

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Iterator<LocaleMapping> iter = this.locales.iterator();
        while (iter.hasNext()) {
            LocaleMapping loc = iter.next();
            sb.append(loc.getLocale());
            String localLocale = loc.getLocalLocale();
            if (!localLocale.equals(loc.getLocale())) {
                sb.append('(');
                sb.append(localLocale);
                sb.append(')');
            }
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(']');
        return sb.toString();
    }

    public LocaleMapping findByLocalLocale(String localLocale) {
        for (LocaleMapping loc : this.locales) {
            if (!loc.getLocalLocale().equals(localLocale)) continue;
            return loc;
        }
        return null;
    }

    public LocaleMapping findByCanonicalLocale(String canonicalLocale) {
        for (LocaleMapping loc : this.locales) {
            if (!loc.getLocale().equals(canonicalLocale)) continue;
            return loc;
        }
        return null;
    }

    @Override
    public int size() {
        return this.locales.size();
    }

    @Override
    public boolean isEmpty() {
        return this.locales.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.locales.contains(o);
    }

    @Override
    public Iterator<LocaleMapping> iterator() {
        return this.locales.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.locales.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.locales.toArray(a);
    }

    @Override
    public boolean add(LocaleMapping e) {
        return this.locales.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.locales.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.locales.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends LocaleMapping> c) {
        return this.locales.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends LocaleMapping> c) {
        return this.locales.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.locales.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.locales.retainAll(c);
    }

    @Override
    public void clear() {
        this.locales.clear();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.locales).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.locales).hashCode();
    }

    @Override
    public LocaleMapping get(int index) {
        return this.locales.get(index);
    }

    @Override
    public LocaleMapping set(int index, LocaleMapping element) {
        return this.locales.set(index, element);
    }

    @Override
    public void add(int index, LocaleMapping element) {
        this.locales.add(index, element);
    }

    @Override
    public LocaleMapping remove(int index) {
        return this.locales.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.locales.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.locales.lastIndexOf(o);
    }

    @Override
    public ListIterator<LocaleMapping> listIterator() {
        return this.locales.listIterator();
    }

    @Override
    public ListIterator<LocaleMapping> listIterator(int index) {
        return this.locales.listIterator(index);
    }

    @Override
    public List<LocaleMapping> subList(int fromIndex, int toIndex) {
        return this.locales.subList(fromIndex, toIndex);
    }
}

