/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands;

import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableProjectCommand;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.PushPullOptions;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.etag.ETagCache;
import org.zanata.client.etag.ETagCacheReaderWriter;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.util.PathUtil;

public abstract class PushPullCommand<O extends PushPullOptions>
extends ConfigurableProjectCommand<O> {
    private static final Logger log = LoggerFactory.getLogger(PushPullCommand.class);
    protected static final String PROJECT_TYPE_OFFLINE_PO = "offlinepo";
    protected final ISourceDocResource sourceDocResource;
    protected final ITranslatedDocResource translationResources;
    protected URI uri;
    protected ETagCache eTagCache;
    private Marshaller marshaller;
    private String modulePrefix;

    public PushPullCommand(O opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory);
        this.sourceDocResource = sourceDocResource;
        this.translationResources = translationResources;
        this.uri = uri;
        this.modulePrefix = opts.getEnableModules() ? ((PushPullOptions)this.getOpts()).getCurrentModule() + opts.getModuleSuffix() : "";
        this.loadETagCache();
    }

    private PushPullCommand(O opts, ZanataProxyFactory factory) {
        this(opts, factory, factory.getSourceDocResource(opts.getProj(), opts.getProjectVersion()), factory.getTranslatedDocResource(opts.getProj(), opts.getProjectVersion()), factory.getResourceURI(opts.getProj(), opts.getProjectVersion()));
    }

    public PushPullCommand(O opts) {
        this(opts, OptionsUtil.createRequestFactory(opts));
    }

    protected void confirmWithUser(String message) throws IOException {
        if (((PushPullOptions)this.getOpts()).isInteractiveMode()) {
            Console console = System.console();
            if (console == null) {
                throw new RuntimeException("console not available: please run Maven from a console, or use batch mode option (-B)");
            }
            console.printf(message + "\nAre you sure (y/n)? ", new Object[0]);
            PushPullCommand.expectYes(console);
        }
    }

    protected static void expectYes(Console console) throws IOException {
        String line = console.readLine();
        if (line == null) {
            throw new IOException("console stream closed");
        }
        if (!line.toLowerCase().equals("y") && !line.toLowerCase().equals("yes")) {
            throw new RuntimeException("operation aborted by user");
        }
    }

    protected void debug(Object jaxbElement) {
        try {
            if (((PushPullOptions)this.getOpts()).isDebugSet()) {
                StringWriter writer = new StringWriter();
                this.getMarshaller().marshal(jaxbElement, (Writer)writer);
                log.debug("{}", (Object)writer);
            }
        }
        catch (JAXBException e) {
            log.debug(e.toString(), (Throwable)e);
        }
    }

    private Marshaller getMarshaller() throws JAXBException {
        if (this.marshaller == null) {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{Resource.class, TranslationsResource.class});
            this.marshaller = jc.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
        }
        return this.marshaller;
    }

    protected String qualifiedDocName(String localDocName) {
        String qualifiedDocName = this.modulePrefix + localDocName;
        return qualifiedDocName;
    }

    protected String unqualifiedDocName(String qualifiedDocName) {
        assert (qualifiedDocName.startsWith(this.modulePrefix));
        return qualifiedDocName.substring(this.modulePrefix.length());
    }

    protected boolean belongsToCurrentModule(String qualifiedDocName) {
        return qualifiedDocName.startsWith(this.modulePrefix);
    }

    protected List<String> getQualifiedDocNamesForCurrentModuleFromServer() {
        List<ResourceMeta> remoteDocList = this.getDocListForProjectIterationFromServer();
        ArrayList<String> docNames = new ArrayList<String>();
        for (ResourceMeta doc : remoteDocList) {
            String qualifiedDocName = doc.getName();
            if (((PushPullOptions)this.getOpts()).getEnableModules()) {
                if (this.belongsToCurrentModule(qualifiedDocName)) {
                    docNames.add(qualifiedDocName);
                    continue;
                }
                log.debug("found extra-modular document: {}", (Object)qualifiedDocName);
                continue;
            }
            docNames.add(qualifiedDocName);
        }
        return docNames;
    }

    protected List<ResourceMeta> getDocListForProjectIterationFromServer() {
        ClientResponse getResponse = this.sourceDocResource.get(null);
        ClientUtility.checkResult((ClientResponse)getResponse, (URI)this.uri);
        List remoteDocList = (List)getResponse.getEntity();
        return remoteDocList;
    }

    public static LocaleList getLocaleMapList(LocaleList projectLocales, String[] locales) {
        if (locales == null || locales.length <= 0) {
            return projectLocales;
        }
        LocaleList effectiveLocales = new LocaleList();
        for (String locale : locales) {
            boolean foundLocale = false;
            for (LocaleMapping lm : projectLocales) {
                if (!lm.getLocale().equals(locale) && (lm.getMapFrom() == null || !lm.getMapFrom().equals(locale))) continue;
                effectiveLocales.add(lm);
                foundLocale = true;
                break;
            }
            if (foundLocale) continue;
            throw new ConfigException("Specified locale '" + locale + "' was not found in zanata.xml!");
        }
        return effectiveLocales;
    }

    protected void loadETagCache() {
        try {
            String location = ".zanata-cache" + File.separator + "etag-cache.xml";
            if (this.modulePrefix != null && !this.modulePrefix.trim().isEmpty()) {
                location = this.modulePrefix + File.separator + location;
            }
            this.eTagCache = ETagCacheReaderWriter.readCache(new FileInputStream(location));
        }
        catch (Exception e) {
            this.eTagCache = new ETagCache();
        }
    }

    protected void storeETagCache() {
        try {
            File targetFile;
            String location = ".zanata-cache" + File.separator + "etag-cache.xml";
            if (this.modulePrefix != null && !this.modulePrefix.trim().isEmpty()) {
                location = this.modulePrefix + File.separator + location;
            }
            if (!(targetFile = new File(location)).exists()) {
                PathUtil.makeDirs((File)targetFile.getParentFile());
            }
            ETagCacheReaderWriter.writeCache(this.eTagCache, new FileOutputStream(location));
        }
        catch (IOException e) {
            log.warn("Could not create Zanata ETag cache file. Will proceed without it.");
        }
    }
}

