/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.pull;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.pull.PullOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.util.PathUtil;

public class RawPullStrategy {
    private static final Logger log = LoggerFactory.getLogger(RawPullStrategy.class);
    private PullOptions opts;

    public void setPullOptions(PullOptions opts) {
        this.opts = opts;
    }

    public void writeSrcFile(String localDocName, InputStream srcFile) throws IOException {
        if (srcFile == null) {
            throw new RuntimeException("no data for downloaded file " + localDocName);
        }
        File srcDir = this.opts.getSrcDir();
        File file = new File(srcDir, localDocName);
        this.logAndStreamToFile(srcFile, file);
    }

    public void writeTransFile(String localDocName, LocaleMapping localeMapping, InputStream transFile) throws IOException {
        if (transFile == null) {
            throw new RuntimeException("no data for downloaded file " + localDocName);
        }
        File transDir = new File(this.opts.getTransDir(), localeMapping.getLocalLocale());
        File file = new File(transDir, localDocName);
        this.logAndStreamToFile(transFile, file);
    }

    private void logAndStreamToFile(InputStream stream, File file) throws FileNotFoundException, IOException {
        if (file.exists()) {
            log.warn("overwriting existing document at [{}]", (Object)file.getAbsolutePath());
        } else {
            log.info("writing new document to [{}]", (Object)file.getAbsolutePath());
        }
        PathUtil.makeDirs((File)file.getParentFile());
        this.writeStreamToFile(stream, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeStreamToFile(InputStream stream, File file) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            int read;
            byte[] buffer = new byte[1024];
            while ((read = stream.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            out.flush();
        }
        finally {
            ((OutputStream)out).close();
        }
    }
}

