/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.jboss.resteasy.client.ClientResponse;
import org.jboss.resteasy.client.ClientResponseFailure;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.adapter.xliff.XliffCommon;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.push.AbstractPushStrategy;
import org.zanata.client.commands.push.GettextDirStrategy;
import org.zanata.client.commands.push.GettextPushStrategy;
import org.zanata.client.commands.push.OfflinePoStrategy;
import org.zanata.client.commands.push.PropertiesStrategy;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.XliffStrategy;
import org.zanata.client.commands.push.XmlStrategy;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.client.util.ConsoleUtils;
import org.zanata.common.LocaleId;
import org.zanata.common.MergeType;
import org.zanata.rest.RestUtil;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.ClientUtility;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.CopyTransStatus;
import org.zanata.rest.dto.ProcessStatus;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TranslationsResource;
import org.zanata.rest.service.AsynchronousProcessResource;
import org.zanata.rest.service.CopyTransResource;

public class PushCommand
extends PushPullCommand<PushOptions> {
    private static final Logger log = LoggerFactory.getLogger(PushCommand.class);
    private static final int POLL_PERIOD = 250;
    private static final String UTF_8 = "UTF-8";
    private static final Map<String, AbstractPushStrategy> strategies = new HashMap<String, AbstractPushStrategy>();
    private CopyTransResource copyTransResource;
    private AsynchronousProcessResource asyncProcessResource;

    public PushCommand(PushOptions opts) {
        super(opts);
        strategies.put("utf8properties", new PropertiesStrategy(UTF_8));
        strategies.put("properties", new PropertiesStrategy());
        strategies.put("gettext", new GettextPushStrategy());
        strategies.put("podir", new GettextDirStrategy());
        strategies.put("xliff", new XliffStrategy());
        strategies.put("xml", new XmlStrategy());
        strategies.put("offlinepo", new OfflinePoStrategy(this.getRequestFactory().getSourceDocResource(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion()), this.uri));
        this.copyTransResource = this.getRequestFactory().getCopyTransResource();
        this.asyncProcessResource = this.getRequestFactory().getAsynchronousProcessResource();
    }

    public PushCommand(PushOptions opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory, sourceDocResource, translationResources, uri);
        strategies.put("utf8properties", new PropertiesStrategy(UTF_8));
        strategies.put("properties", new PropertiesStrategy());
        strategies.put("gettext", new GettextPushStrategy());
        strategies.put("podir", new GettextDirStrategy());
        strategies.put("xliff", new XliffStrategy());
        strategies.put("xml", new XmlStrategy());
        strategies.put("offlinepo", new OfflinePoStrategy(this.getRequestFactory().getSourceDocResource(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion()), this.uri));
        this.copyTransResource = factory.getCopyTransResource();
        this.asyncProcessResource = factory.getAsynchronousProcessResource();
    }

    private AbstractPushStrategy getStrategy(String strategyType) {
        AbstractPushStrategy strat = strategies.get(strategyType);
        if (strat == null) {
            throw new RuntimeException("unknown project type: " + ((PushOptions)this.getOpts()).getProjectType());
        }
        strat.setPushOptions((PushOptions)this.getOpts());
        strat.init();
        return strat;
    }

    public static void logOptions(Logger logger, PushOptions opts) {
        if (!logger.isInfoEnabled()) {
            return;
        }
        logger.info("Server: {}", (Object)opts.getUrl());
        logger.info("Project: {}", (Object)opts.getProj());
        logger.info("Version: {}", (Object)opts.getProjectVersion());
        logger.info("Username: {}", (Object)opts.getUsername());
        logger.info("Project type: {}", (Object)opts.getProjectType());
        logger.info("Source language: {}", (Object)opts.getSourceLang());
        String copyTransMssg = "" + opts.getCopyTrans();
        if (opts.getCopyTrans() && opts.getPushType() == PushPullType.Trans) {
            copyTransMssg = "disabled since pushType=Trans";
        }
        logger.info("Copy previous translations: {}", (Object)copyTransMssg);
        logger.info("Merge type: {}", (Object)opts.getMergeType());
        logger.info("Enable modules: {}", (Object)opts.getEnableModules());
        if (opts.getEnableModules()) {
            logger.info("Current module: {}", (Object)opts.getCurrentModule());
            if (opts.isRootModule()) {
                logger.info("Root module: YES");
                if (logger.isDebugEnabled()) {
                    logger.debug("Modules: {}", (Object)StringUtils.join(opts.getAllModules(), (String)", "));
                }
            }
        }
        logger.info("Include patterns: {}", (Object)StringUtils.join(opts.getIncludes(), (String)" "));
        logger.info("Exclude patterns: {}", (Object)StringUtils.join(opts.getExcludes(), (String)" "));
        logger.info("Case sensitive: {}", (Object)opts.getCaseSensitive());
        logger.info("Default excludes: {}", (Object)opts.getDefaultExcludes());
        log.info("Exclude locale filenames: {}", (Object)opts.getExcludeLocaleFilenames());
        if (opts.getPushType() == PushPullType.Trans) {
            logger.info("Pushing target documents only");
            logger.info("Locales to push: {}", (Object)opts.getLocaleMapList());
        } else if (opts.getPushType() == PushPullType.Source) {
            logger.info("Pushing source documents only");
        } else {
            logger.info("Pushing source and target documents");
            logger.info("Locales to push: {}", (Object)opts.getLocaleMapList());
        }
        logger.info("Current directory: {}", (Object)System.getProperty("user.dir"));
        logger.info("Source directory (originals): {}", (Object)opts.getSrcDir());
        if (opts.getPushType() == PushPullType.Both || opts.getPushType() == PushPullType.Trans) {
            logger.info("Target base directory (translations): {}", (Object)opts.getTransDir());
        }
        if (opts.getFromDoc() != null) {
            logger.info("From document: {}", (Object)opts.getFromDoc());
        }
        if (opts.isDryRun()) {
            logger.info("DRY RUN: no permanent changes will be made");
        }
        if (opts.getProjectType().equalsIgnoreCase("xliff")) {
            PushCommand.validateValidation(opts.getValidate());
            log.info("Validate option: {}", (Object)opts.getValidate());
        }
    }

    private static void validateValidation(String validate) {
        if (!validate.equalsIgnoreCase(XliffCommon.ValidationType.CONTENT.toString()) && !validate.equalsIgnoreCase(XliffCommon.ValidationType.XSD.toString())) {
            throw new RuntimeException("unknown validate option: " + validate);
        }
    }

    private boolean mergeAuto() {
        return ((PushOptions)this.getOpts()).getMergeType().toUpperCase().equals(MergeType.AUTO.name());
    }

    private boolean pushSource() {
        return ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Source;
    }

    private boolean pushTrans() {
        return ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans;
    }

    @Override
    public void run() throws Exception {
        PushCommand.logOptions(log, (PushOptions)this.getOpts());
        this.pushCurrentModule();
        if (this.pushSource() && ((PushOptions)this.getOpts()).getEnableModules() && ((PushOptions)this.getOpts()).isRootModule()) {
            List<String> obsoleteDocs = this.getObsoleteDocNamesForProjectIterationFromServer();
            log.info("found {} docs in obsolete modules (or no module): {}", (Object)obsoleteDocs.size(), obsoleteDocs);
            if (((PushOptions)this.getOpts()).getDeleteObsoleteModules() && !obsoleteDocs.isEmpty()) {
                this.confirmWithUser("Do you want to delete all documents from the server which don't belong to any module in the Maven reactor?\n");
                this.deleteSourceDocsFromServer(obsoleteDocs);
            } else {
                log.warn("found {} docs in obsolete modules (or no module).  use -Dzanata.deleteObsoleteModules to delete them", (Object)obsoleteDocs.size());
            }
        }
    }

    protected List<String> getObsoleteDocNamesForProjectIterationFromServer() {
        if (!((PushOptions)this.getOpts()).getEnableModules()) {
            return Collections.emptyList();
        }
        List<ResourceMeta> remoteDocList = this.getDocListForProjectIterationFromServer();
        Pattern p = Pattern.compile(((PushOptions)this.getOpts()).getDocNameRegex());
        HashSet<String> modules = new HashSet<String>(((PushOptions)this.getOpts()).getAllModules());
        ArrayList<String> obsoleteDocs = new ArrayList<String>();
        for (ResourceMeta doc : remoteDocList) {
            String docName = doc.getName();
            Matcher matcher = p.matcher(docName);
            if (matcher.matches()) {
                String module = matcher.group(1);
                if (modules.contains(module)) {
                    log.debug("doc {} belongs to non-obsolete module {}", (Object)docName, (Object)module);
                    continue;
                }
                obsoleteDocs.add(docName);
                log.info("doc {} belongs to obsolete module {}", (Object)docName, (Object)module);
                continue;
            }
            obsoleteDocs.add(docName);
            log.warn("doc {} doesn't belong to any module", (Object)docName);
        }
        return obsoleteDocs;
    }

    private void pushCurrentModule() throws IOException, RuntimeException {
        AbstractPushStrategy strat = this.getStrategy(((PushOptions)this.getOpts()).getProjectType());
        File sourceDir = ((PushOptions)this.getOpts()).getSrcDir();
        if (!sourceDir.exists() && !strat.isTransOnly()) {
            if (((PushOptions)this.getOpts()).getEnableModules()) {
                log.info("source directory '" + sourceDir + "' not found; skipping docs push for module " + ((PushOptions)this.getOpts()).getCurrentModule());
                return;
            }
            throw new RuntimeException("directory '" + sourceDir + "' does not exist - check " + ((PushOptions)this.getOpts()).getSrcDirParameterName() + " option");
        }
        final StringSet extensions = strat.getExtensions();
        Set<String> unsortedDocNames = strat.findDocNames(sourceDir, ((PushOptions)this.getOpts()).getIncludes(), ((PushOptions)this.getOpts()).getExcludes(), ((PushOptions)this.getOpts()).getDefaultExcludes(), ((PushOptions)this.getOpts()).getCaseSensitive(), ((PushOptions)this.getOpts()).getExcludeLocaleFilenames());
        TreeSet<String> localDocNames = new TreeSet<String>(unsortedDocNames);
        SortedSet<String> docsToPush = localDocNames;
        if (((PushOptions)this.getOpts()).getFromDoc() != null) {
            if (((PushOptions)this.getOpts()).getEnableModules()) {
                if (this.belongsToCurrentModule(((PushOptions)this.getOpts()).getFromDoc())) {
                    docsToPush = this.getDocsAfterFromDoc(this.unqualifiedDocName(((PushOptions)this.getOpts()).getFromDoc()), localDocNames);
                }
            } else {
                docsToPush = this.getDocsAfterFromDoc(((PushOptions)this.getOpts()).getFromDoc(), localDocNames);
            }
        }
        if (localDocNames.isEmpty()) {
            log.info("No source documents found.");
        } else {
            log.info("Found source documents:");
            for (String docName : localDocNames) {
                if (docsToPush.contains(docName)) {
                    log.info("           {}", (Object)docName);
                    continue;
                }
                log.info("(to skip)  {}", (Object)docName);
            }
        }
        List<String> obsoleteDocs = Collections.emptyList();
        if (this.pushSource() && !strat.isTransOnly()) {
            obsoleteDocs = this.getObsoleteDocsInModuleFromServer(localDocNames);
        }
        if (obsoleteDocs.isEmpty()) {
            if (localDocNames.isEmpty()) {
                log.info("no documents in module: {}; nothing to do", (Object)((PushOptions)this.getOpts()).getCurrentModule());
                return;
            }
        } else {
            log.warn("Found {} obsolete docs on the server which will be DELETED", (Object)obsoleteDocs.size());
            log.info("Obsolete docs: {}", obsoleteDocs);
        }
        if (this.pushTrans() && ((PushOptions)this.getOpts()).getLocaleMapList() == null) {
            throw new ConfigException("pushType set to '" + (Object)((Object)((PushOptions)this.getOpts()).getPushType()) + "', but zanata.xml contains no <locales>");
        }
        if (this.pushTrans()) {
            log.warn("pushType set to '" + (Object)((Object)((PushOptions)this.getOpts()).getPushType()) + "': existing translations on server may be overwritten/deleted");
        }
        if (strat.isTransOnly()) {
            switch (((PushOptions)this.getOpts()).getPushType()) {
                case Source: {
                    log.error("You are trying to push source only, but source is not available for this project type.\n");
                    log.info("Nothing to do. Aborting\n");
                    return;
                }
                case Both: {
                    log.warn("Source is not available for this project type. Source will not be pushed.\n");
                    this.confirmWithUser("This will overwrite existing TRANSLATIONS on the server.\n");
                    break;
                }
                case Trans: {
                    this.confirmWithUser("This will overwrite existing TRANSLATIONS on the server.\n");
                }
            }
        } else if (this.pushTrans()) {
            if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
                this.confirmWithUser("This will overwrite existing documents AND TRANSLATIONS on the server, and delete obsolete documents.\n");
            } else if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans) {
                this.confirmWithUser("This will overwrite existing TRANSLATIONS on the server.\n");
            }
        } else {
            this.confirmWithUser("This will overwrite existing source documents on the server, and delete obsolete documents.\n");
        }
        for (String localDocName : docsToPush) {
            try {
                Resource srcDoc;
                final String qualifiedDocName = this.qualifiedDocName(localDocName);
                final String docUri = RestUtil.convertToDocumentURIId((String)qualifiedDocName);
                if (strat.isTransOnly()) {
                    srcDoc = null;
                } else {
                    srcDoc = strat.loadSrcDoc(sourceDir, localDocName);
                    srcDoc.setName(qualifiedDocName);
                    this.debug(srcDoc);
                    if (this.pushSource()) {
                        this.pushSrcDocToServer(docUri, srcDoc, extensions);
                    }
                }
                if (this.pushTrans()) {
                    strat.visitTranslationResources(localDocName, srcDoc, new TranslationResourcesVisitor(){

                        @Override
                        public void visit(LocaleMapping locale, TranslationsResource targetDoc) {
                            PushCommand.this.debug(targetDoc);
                            PushCommand.this.pushTargetDocToServer(docUri, locale, qualifiedDocName, targetDoc, extensions);
                        }
                    });
                }
                if (!((PushOptions)this.getOpts()).getCopyTrans() || ((PushOptions)this.getOpts()).getPushType() != PushPullType.Both && ((PushOptions)this.getOpts()).getPushType() != PushPullType.Source) continue;
                this.copyTransForDocument(qualifiedDocName);
            }
            catch (Exception e) {
                String message = "Operation failed: " + e.getMessage() + "\n\n" + "    To retry from the last document, please set the following option(s):\n\n" + "        ";
                if (((PushOptions)this.getOpts()).getEnableModules()) {
                    message = message + "--resume-from " + ((PushOptions)this.getOpts()).getCurrentModule(true) + " ";
                }
                message = message + ((PushOptions)this.getOpts()).buildFromDocArgument(this.qualifiedDocName(localDocName)) + "\n\n.";
                log.error(message);
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        this.deleteSourceDocsFromServer(obsoleteDocs);
    }

    private SortedSet<String> getDocsAfterFromDoc(String fromDoc, SortedSet<String> docNames) {
        if (!docNames.contains(fromDoc)) {
            throw new RuntimeException("Document with id " + fromDoc + " not found, unable to start push from unknown document. Aborting.");
        }
        SortedSet<String> docsToPush = docNames.tailSet(fromDoc);
        int numSkippedDocs = docNames.size() - docsToPush.size();
        log.info("Skipping {} document(s) before {}.", (Object)numSkippedDocs, (Object)fromDoc);
        return docsToPush;
    }

    private List<String> getObsoleteDocsInModuleFromServer(Set<String> localDocNames) {
        List<String> qualifiedDocNames = this.getQualifiedDocNamesForCurrentModuleFromServer();
        ArrayList<String> obsoleteDocs = new ArrayList<String>(qualifiedDocNames.size());
        for (String qualifiedDocName : qualifiedDocNames) {
            String unqualifiedDocName = this.unqualifiedDocName(qualifiedDocName);
            if (localDocNames.contains(unqualifiedDocName)) continue;
            obsoleteDocs.add(qualifiedDocName);
        }
        return obsoleteDocs;
    }

    private void deleteSourceDocsFromServer(List<String> qualifiedDocNames) {
        for (String qualifiedDocName : qualifiedDocNames) {
            this.deleteSourceDocFromServer(qualifiedDocName);
        }
    }

    private void pushSrcDocToServer(String docUri, Resource srcDoc, StringSet extensions) {
        if (!((PushOptions)this.getOpts()).isDryRun()) {
            log.info("pushing source doc [name={} size={}] to server", (Object)srcDoc.getName(), (Object)srcDoc.getTextFlows().size());
            ConsoleUtils.startProgressFeedback();
            ProcessStatus status = this.asyncProcessResource.startSourceDocCreationOrUpdate(docUri, ((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), srcDoc, (Set)extensions, false);
            boolean waitForCompletion = true;
            while (waitForCompletion) {
                switch (status.getStatusCode()) {
                    case Failed: {
                        throw new RuntimeException("Failed while pushing document: " + status.getMessages());
                    }
                    case Finished: {
                        waitForCompletion = false;
                        break;
                    }
                    case Running: {
                        ConsoleUtils.setProgressFeedbackMessage("Pushing ...");
                        break;
                    }
                    case Waiting: {
                        ConsoleUtils.setProgressFeedbackMessage("Waiting to start ...");
                        break;
                    }
                    case NotAccepted: {
                        status = this.asyncProcessResource.startSourceDocCreationOrUpdate(docUri, ((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), srcDoc, (Set)extensions, false);
                        ConsoleUtils.setProgressFeedbackMessage("Waiting for other clients ...");
                    }
                }
                PushCommand.wait(250);
                status = this.asyncProcessResource.getProcessStatus(status.getUrl());
            }
            ConsoleUtils.endProgressFeedback();
        } else {
            log.info("pushing source doc [name={} size={}] to server (skipped due to dry run)", (Object)srcDoc.getName(), (Object)srcDoc.getTextFlows().size());
        }
    }

    public List<TranslationsResource> splitIntoBatch(TranslationsResource doc, int maxBatchSize) {
        ArrayList<TranslationsResource> targetDocList = new ArrayList<TranslationsResource>();
        int numTargets = doc.getTextFlowTargets().size();
        if (numTargets > maxBatchSize && this.mergeAuto()) {
            int numBatches = numTargets / maxBatchSize;
            if (numTargets % maxBatchSize != 0) {
                ++numBatches;
            }
            int fromIndex = 0;
            for (int i = 1; i <= numBatches; ++i) {
                TranslationsResource resource = new TranslationsResource();
                resource.setExtensions(doc.getExtensions());
                resource.setLinks(doc.getLinks());
                resource.setRevision(doc.getRevision());
                int toIndex = i * maxBatchSize > numTargets ? numTargets : i * maxBatchSize;
                resource.getTextFlowTargets().addAll(doc.getTextFlowTargets().subList(fromIndex, toIndex));
                fromIndex = i * maxBatchSize;
                targetDocList.add(resource);
            }
        } else {
            targetDocList.add(doc);
        }
        return targetDocList;
    }

    private void pushTargetDocToServer(String docUri, LocaleMapping locale, String localDocName, TranslationsResource targetDoc, StringSet extensions) {
        if (!((PushOptions)this.getOpts()).isDryRun()) {
            log.info("Pushing target doc [name={} size={} client-locale={}] to server [locale={}]", new Object[]{localDocName, targetDoc.getTextFlowTargets().size(), locale.getLocalLocale(), locale.getLocale()});
            ConsoleUtils.startProgressFeedback();
            ProcessStatus status = this.asyncProcessResource.startTranslatedDocCreationOrUpdate(docUri, ((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), new LocaleId(locale.getLocale()), targetDoc, (Set)extensions, ((PushOptions)this.getOpts()).getMergeType());
            boolean waitForCompletion = true;
            while (waitForCompletion) {
                switch (status.getStatusCode()) {
                    case Failed: {
                        throw new RuntimeException("Failed while pushing document translations: " + status.getMessages());
                    }
                    case Finished: {
                        waitForCompletion = false;
                        break;
                    }
                    case Running: {
                        ConsoleUtils.setProgressFeedbackMessage(status.getPercentageComplete() + "%");
                        break;
                    }
                    case Waiting: {
                        ConsoleUtils.setProgressFeedbackMessage("Waiting to start ...");
                        break;
                    }
                    case NotAccepted: {
                        status = this.asyncProcessResource.startTranslatedDocCreationOrUpdate(docUri, ((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), new LocaleId(locale.getLocale()), targetDoc, (Set)extensions, ((PushOptions)this.getOpts()).getMergeType());
                        ConsoleUtils.setProgressFeedbackMessage("Waiting for other clients ...");
                    }
                }
                PushCommand.wait(250);
                status = this.asyncProcessResource.getProcessStatus(status.getUrl());
            }
            ConsoleUtils.endProgressFeedback();
            if (status.getMessages().size() > 0) {
                log.warn("Pushed translations with warnings:");
                for (String mssg : status.getMessages()) {
                    log.warn(mssg);
                }
            }
        } else {
            log.info("pushing target doc [name={} size={} client-locale={}] to server [locale={}] (skipped due to dry run)", new Object[]{localDocName, targetDoc.getTextFlowTargets().size(), locale.getLocalLocale(), locale.getLocale()});
        }
    }

    private void deleteSourceDocFromServer(String qualifiedDocName) {
        if (!((PushOptions)this.getOpts()).isDryRun()) {
            log.info("deleting resource {} from server", (Object)qualifiedDocName);
            String docUri = RestUtil.convertToDocumentURIId((String)qualifiedDocName);
            ClientResponse deleteResponse = this.sourceDocResource.deleteResource(docUri);
            ClientUtility.checkResult((ClientResponse)deleteResponse, (URI)this.uri);
            deleteResponse.releaseConnection();
        } else {
            log.info("deleting resource {} from server (skipped due to dry run)", (Object)qualifiedDocName);
        }
    }

    private void copyTransForDocument(String docName) {
        CopyTransStatus copyTransStatus;
        if (((PushOptions)this.getOpts()).isDryRun()) {
            log.info("Skipping Copy Trans for " + docName + " (due to dry run)");
            return;
        }
        log.info("Running Copy Trans for " + docName);
        try {
            this.copyTransResource.startCopyTrans(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), docName);
        }
        catch (Exception ex) {
            log.warn("Could not start Copy Trans for above document. Proceeding");
            return;
        }
        try {
            copyTransStatus = this.copyTransResource.getCopyTransStatus(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), docName);
        }
        catch (ClientResponseFailure failure) {
            if (failure.getResponse().getResponseStatus() == Response.Status.NOT_FOUND) {
                if (this.getRequestFactory().compareToServerVersion("1.8.0-SNAPSHOT") < 0) {
                    log.warn("Copy Trans not started (Incompatible server version.)");
                    return;
                }
                throw new RuntimeException("Could not invoke copy trans. The service was not available (404)");
            }
            if (failure.getCause() != null) {
                throw new RuntimeException("Problem invoking copy trans.", failure.getCause());
            }
            throw new RuntimeException("Problem invoking copy trans: [Server response code:" + failure.getResponse().getResponseStatus().getStatusCode() + "]");
        }
        ConsoleUtils.startProgressFeedback();
        while (copyTransStatus.isInProgress()) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for Copy Trans to finish.");
            }
            ConsoleUtils.setProgressFeedbackMessage(copyTransStatus.getPercentageComplete() + "%");
            copyTransStatus = this.copyTransResource.getCopyTransStatus(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), docName);
        }
        ConsoleUtils.endProgressFeedback();
        if (copyTransStatus.getPercentageComplete() < 100) {
            log.warn("Copy Trans for the above document stopped unexpectedly.");
        }
    }

    private static void wait(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting");
        }
    }

    public static interface TranslationResourcesVisitor {
        public void visit(LocaleMapping var1, TranslationsResource var2);
    }
}

