/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.codec.binary.Hex;
import org.jboss.resteasy.client.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.PushPullCommand;
import org.zanata.client.commands.PushPullType;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.RawPushStrategy;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.exceptions.ConfigException;
import org.zanata.client.util.ConsoleUtils;
import org.zanata.rest.DocumentFileUploadForm;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.IFileResource;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.ChunkUploadResponse;

public class RawPushCommand
extends PushPullCommand<PushOptions> {
    private static final Logger log = LoggerFactory.getLogger(PushCommand.class);
    protected final IFileResource fileResource;

    public RawPushCommand(PushOptions opts) {
        super(opts);
        this.fileResource = this.getRequestFactory().getFileResource();
    }

    public RawPushCommand(PushOptions opts, ZanataProxyFactory factory, ISourceDocResource sourceDocResource, ITranslatedDocResource translationResources, URI uri) {
        super(opts, factory, sourceDocResource, translationResources, uri);
        this.fileResource = factory.getFileResource();
    }

    @Override
    public void run() throws IOException {
        PushCommand.logOptions(log, (PushOptions)this.getOpts());
        log.warn("Using EXPERIMENTAL project type 'file'.");
        File sourceDir = ((PushOptions)this.getOpts()).getSrcDir();
        if (!sourceDir.exists()) {
            boolean enableModules = ((PushOptions)this.getOpts()).getEnableModules();
            if (enableModules) {
                log.warn("enableModules=true but multi-modules not yet supported for this command. Using single module push.");
                enableModules = false;
            }
            if (enableModules) {
                log.info("source directory '" + sourceDir + "' not found; skipping docs push for module " + ((PushOptions)this.getOpts()).getCurrentModule());
                return;
            }
            throw new RuntimeException("directory '" + sourceDir + "' does not exist - check " + ((PushOptions)this.getOpts()).getSrcDirParameterName() + " option");
        }
        RawPushStrategy strat = new RawPushStrategy();
        strat.setPushOptions((PushOptions)this.getOpts());
        ArrayList<String> types = new ArrayList<String>();
        ClientResponse response = this.fileResource.acceptedFileTypes();
        StringSet serverAcceptedTypes = new StringSet((String)response.getEntity());
        if (((PushOptions)this.getOpts()).getFileTypes() != null) {
            for (String type : ((PushOptions)this.getOpts()).getFileTypes()) {
                if (serverAcceptedTypes.contains((Object)type)) {
                    types.add(type);
                    continue;
                }
                log.warn("Requested type '{}' is not supported by the target server and will be ignored.", (Object)type);
            }
        }
        if (types.isEmpty()) {
            log.info("no valid types specified; nothing to do");
            return;
        }
        String[] srcFiles = strat.getSrcFiles(sourceDir, ((PushOptions)this.getOpts()).getIncludes(), ((PushOptions)this.getOpts()).getExcludes(), types, true, ((PushOptions)this.getOpts()).getCaseSensitive());
        TreeSet<String> localDocNames = new TreeSet<String>(Arrays.asList(srcFiles));
        log.warn("Obsolete document removal is not yet implemented, no documents will be removed from the server.");
        SortedSet<String> docsToPush = localDocNames;
        if (((PushOptions)this.getOpts()).getFromDoc() != null) {
            if (!localDocNames.contains(((PushOptions)this.getOpts()).getFromDoc())) {
                log.error("Document with id {} not found, unable to start push from unknown document. Aborting.", (Object)((PushOptions)this.getOpts()).getFromDoc());
                return;
            }
            docsToPush = localDocNames.tailSet(((PushOptions)this.getOpts()).getFromDoc());
            int numSkippedDocs = localDocNames.size() - docsToPush.size();
            log.info("Skipping {} document(s) before {}.", (Object)numSkippedDocs, (Object)((PushOptions)this.getOpts()).getFromDoc());
        }
        if (docsToPush.isEmpty()) {
            log.info("no documents in module: {}; nothing to do", (Object)((PushOptions)this.getOpts()).getCurrentModule());
            return;
        }
        log.info("Found source documents:");
        for (String docName : localDocNames) {
            if (docsToPush.contains(docName)) {
                log.info("           {}", (Object)docName);
                continue;
            }
            log.info("(to skip)  {}", (Object)docName);
        }
        if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
            if (((PushOptions)this.getOpts()).getLocaleMapList() == null) {
                throw new ConfigException("pushType set to '" + (Object)((Object)((PushOptions)this.getOpts()).getPushType()) + "', but zanata.xml contains no <locales>");
            }
            log.warn("pushType set to '" + (Object)((Object)((PushOptions)this.getOpts()).getPushType()) + "': existing translations on server may be overwritten/deleted");
            if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
                this.confirmWithUser("This will overwrite existing documents AND TRANSLATIONS on the server.\n");
            } else if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Trans) {
                this.confirmWithUser("This will overwrite existing TRANSLATIONS on the server.\n");
            }
        } else {
            this.confirmWithUser("This will overwrite existing documents on the server.\n");
        }
        boolean hasErrors = false;
        for (String localDocName : docsToPush) {
            try {
                final String fileType = this.getExtensionFor(localDocName);
                final String qualifiedDocName = this.qualifiedDocName(localDocName);
                if (((PushOptions)this.getOpts()).getPushType() == PushPullType.Source || ((PushOptions)this.getOpts()).getPushType() == PushPullType.Both) {
                    if (!((PushOptions)this.getOpts()).isDryRun()) {
                        boolean sourcePushed = this.pushSourceDocumentToServer(sourceDir, localDocName, qualifiedDocName, fileType);
                        if (!sourcePushed) {
                            hasErrors = true;
                        }
                    } else {
                        log.info("pushing source doc [qualifiedname={}] to server (skipped due to dry run)", (Object)qualifiedDocName);
                    }
                }
                if (((PushOptions)this.getOpts()).getPushType() != PushPullType.Trans && ((PushOptions)this.getOpts()).getPushType() != PushPullType.Both) continue;
                strat.visitTranslationFiles(localDocName, new RawPushStrategy.TranslationFilesVisitor(){

                    @Override
                    public void visit(LocaleMapping locale, File translatedDoc) {
                        log.info("pushing {} translation of {}", (Object)locale.getLocale(), (Object)qualifiedDocName);
                        RawPushCommand.this.pushDocumentToServer(qualifiedDocName, fileType, locale.getLocale(), translatedDoc);
                    }
                });
            }
            catch (IOException e) {
                log.error("Operation failed: " + e.getMessage() + "\n\n" + "    To retry from the last document, please add the option: {}\n", (Object)((PushOptions)this.getOpts()).buildFromDocArgument(localDocName));
                throw new RuntimeException(e.getMessage(), e);
            }
            catch (RuntimeException e) {
                log.error("Operation failed: " + e.getMessage() + "\n\n" + "    To retry from the last document, please add the option: {}\n", (Object)((PushOptions)this.getOpts()).buildFromDocArgument(localDocName));
                throw new RuntimeException(e.getMessage(), e);
            }
        }
        if (hasErrors) {
            throw new RuntimeException("Push completed with errors, see log for details.");
        }
    }

    private String getExtensionFor(String localDocName) {
        if (localDocName == null || localDocName.length() == 0 || localDocName.endsWith(".") || !localDocName.contains(".")) {
            return null;
        }
        return localDocName.substring(localDocName.lastIndexOf(46) + 1);
    }

    private boolean pushSourceDocumentToServer(File sourceDir, String localDocName, String qualifiedDocName, String fileType) throws IOException {
        log.info("pushing source document [{}] to server", (Object)qualifiedDocName);
        String locale = null;
        File srcFile = new File(sourceDir, localDocName);
        this.pushDocumentToServer(qualifiedDocName, fileType, locale, srcFile);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushDocumentToServer(String docId, String fileType, String locale, File docFile) {
        block11: {
            try {
                String md5hash = this.calculateFileHash(docFile);
                if (docFile.length() <= (long)((PushOptions)this.getOpts()).getChunkSize()) {
                    log.info("    transmitting file [{}] as single chunk", (Object)docFile.getAbsolutePath());
                    FileInputStream fileStream = new FileInputStream(docFile);
                    try {
                        DocumentFileUploadForm uploadForm = this.generateUploadForm(true, true, fileType, md5hash, docFile.length(), fileStream);
                        ClientResponse<ChunkUploadResponse> response = this.uploadDocumentPart(docId, locale, uploadForm);
                        this.checkChunkUploadStatus(response);
                        break block11;
                    }
                    finally {
                        ((InputStream)fileStream).close();
                    }
                }
                StreamChunker chunker = new StreamChunker(docFile, ((PushOptions)this.getOpts()).getChunkSize());
                try {
                    log.info("    transmitting file [{}] as {} chunks", (Object)docFile.getAbsolutePath(), (Object)chunker.totalChunks());
                    Long uploadId = null;
                    for (InputStream chunkStream : chunker) {
                        log.info("        pushing chunk {} of {}", (Object)chunker.currentChunkNumber(), (Object)chunker.totalChunks());
                        boolean isFirst = chunker.currentChunkNumber() == 1;
                        boolean isLast = chunker.getRemainingChunks() == 0;
                        long chunkSize = chunker.currentChunkSize();
                        DocumentFileUploadForm uploadForm = this.generateUploadForm(isFirst, isLast, fileType, md5hash, chunkSize, chunkStream);
                        if (!isFirst) {
                            uploadForm.setUploadId(uploadId);
                        }
                        ClientResponse<ChunkUploadResponse> uploadResponse = this.uploadDocumentPart(docId, locale, uploadForm);
                        this.checkChunkUploadStatus(uploadResponse);
                        if (!isFirst || (uploadId = ((ChunkUploadResponse)uploadResponse.getEntity()).getUploadId()) != null) continue;
                        throw new RuntimeException("server did not return upload id");
                    }
                }
                finally {
                    chunker.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void checkChunkUploadStatus(ClientResponse<ChunkUploadResponse> uploadResponse) {
        if (uploadResponse.getStatus() >= 300) {
            throw new RuntimeException("Server returned error status: " + uploadResponse.getStatus() + ". Error message: " + ((ChunkUploadResponse)uploadResponse.getEntity()).getErrorMessage());
        }
    }

    private DocumentFileUploadForm generateUploadForm(boolean isFirst, boolean isLast, String fileType, String md5hash, long streamSize, InputStream fileStream) {
        DocumentFileUploadForm uploadForm = new DocumentFileUploadForm();
        uploadForm.setFirst(Boolean.valueOf(isFirst));
        uploadForm.setLast(Boolean.valueOf(isLast));
        uploadForm.setFileType(fileType);
        uploadForm.setHash(md5hash);
        uploadForm.setSize(Long.valueOf(streamSize));
        uploadForm.setFileStream(fileStream);
        return uploadForm;
    }

    private ClientResponse<ChunkUploadResponse> uploadDocumentPart(String docName, String locale, DocumentFileUploadForm uploadForm) {
        ConsoleUtils.startProgressFeedback();
        ClientResponse response = locale == null ? this.fileResource.uploadSourceFile(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), docName, uploadForm) : this.fileResource.uploadTranslationFile(((PushOptions)this.getOpts()).getProj(), ((PushOptions)this.getOpts()).getProjectVersion(), locale, docName, ((PushOptions)this.getOpts()).getMergeType(), uploadForm);
        log.debug("response from server: {}", response.getEntity());
        ConsoleUtils.endProgressFeedback();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String calculateFileHash(File srcFile) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            InputStream fileStream = new FileInputStream(srcFile);
            try {
                fileStream = new DigestInputStream(fileStream, md);
                byte[] buffer = new byte[256];
                while (fileStream.read(buffer) > 0) {
                }
            }
            finally {
                fileStream.close();
            }
            String md5hash = new String(Hex.encodeHex((byte[])md.digest()));
            return md5hash;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static class StreamChunker
    implements Iterable<InputStream>,
    Closeable {
        private int totalChunkCount;
        private int chunksRetrieved;
        private File file;
        private byte[] buffer;
        private InputStream fileStream;
        private int actualChunkSize;

        public StreamChunker(File file, int chunkSize) throws FileNotFoundException {
            this.file = file;
            this.buffer = new byte[chunkSize];
            this.chunksRetrieved = 0;
            this.totalChunkCount = (int)(file.length() / (long)chunkSize + (long)(file.length() % (long)chunkSize == 0L ? 0 : 1));
            this.fileStream = new FileInputStream(file);
        }

        @Override
        public void close() throws IOException {
            this.fileStream.close();
        }

        public int totalChunks() {
            return this.totalChunkCount;
        }

        public int currentChunkNumber() {
            return this.chunksRetrieved;
        }

        public int currentChunkSize() {
            return this.actualChunkSize;
        }

        public int getRemainingChunks() {
            return this.totalChunkCount - this.chunksRetrieved;
        }

        private InputStream getNextChunk() {
            if (this.chunksRetrieved == this.totalChunkCount) {
                throw new IllegalStateException("getNextChunk() must not be called after all chunks have been retrieved");
            }
            try {
                this.actualChunkSize = this.fileStream.read(this.buffer);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++this.chunksRetrieved;
            if (this.chunksRetrieved == this.totalChunkCount) {
                try {
                    this.fileStream.close();
                }
                catch (IOException e) {
                    log.error("failed to close input stream for file " + this.file.getAbsolutePath(), (Throwable)e);
                }
                this.fileStream = null;
            }
            return new ByteArrayInputStream(this.buffer, 0, this.actualChunkSize);
        }

        @Override
        public Iterator<InputStream> iterator() {
            return new Iterator<InputStream>(){

                @Override
                public boolean hasNext() {
                    return StreamChunker.this.chunksRetrieved < StreamChunker.this.totalChunkCount;
                }

                @Override
                public InputStream next() {
                    return StreamChunker.this.getNextChunk();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

