/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.push.AbstractCommonPushStrategy;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.config.LocaleMapping;

public class RawPushStrategy
extends AbstractCommonPushStrategy<PushOptions> {
    private static final Logger log = LoggerFactory.getLogger(RawPushStrategy.class);

    public void visitTranslationFiles(String sourceDocument, TranslationFilesVisitor visitor) {
        if (this.getOpts().getLocaleMapList() == null) {
            log.error("Locale mapping list not found, unable to push translations. Check mapping in zanata.xml");
            return;
        }
        for (LocaleMapping localeMapping : this.getOpts().getLocaleMapList()) {
            String locale = localeMapping.getLocalLocale();
            File localeDir = new File(this.getOpts().getTransDir(), locale);
            File translationFile = new File(localeDir, sourceDocument);
            if (translationFile.canRead()) {
                visitor.visit(localeMapping, translationFile);
                continue;
            }
            Object[] args = new Object[]{localeMapping.getLocale(), localeMapping.getMapFrom(), translationFile.getAbsolutePath()};
            log.warn("No translation file found for locale {} mapped by {}. Expected at {}", args);
        }
    }

    public static interface TranslationFilesVisitor {
        public void visit(LocaleMapping var1, File var2);
    }
}

