/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.stats;

import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zanata.client.commands.ConfigurableCommand;
import org.zanata.client.commands.stats.ConsoleStatisticsOutput;
import org.zanata.client.commands.stats.ContainerStatisticsCommandOutput;
import org.zanata.client.commands.stats.CsvStatisticsOutput;
import org.zanata.client.commands.stats.GetStatisticsOptions;
import org.zanata.client.config.LocaleMapping;
import org.zanata.client.util.ConsoleUtils;
import org.zanata.rest.dto.stats.ContainerTranslationStatistics;
import org.zanata.rest.service.StatisticsResource;

public class GetStatisticsCommand
extends ConfigurableCommand<GetStatisticsOptions> {
    private static final Logger log = LoggerFactory.getLogger(GetStatisticsCommand.class);
    private StatisticsResource statsResource = this.getRequestFactory().getStatisticsResource();

    public GetStatisticsCommand(GetStatisticsOptions opts) {
        super(opts);
    }

    @Override
    public void run() throws Exception {
        ContainerStatisticsCommandOutput statsOutput;
        String[] localeListArg = null;
        if (((GetStatisticsOptions)this.getOpts()).getLocaleMapList() != null) {
            ArrayList<String> localeList = new ArrayList<String>();
            for (LocaleMapping locMapping : ((GetStatisticsOptions)this.getOpts()).getLocaleMapList()) {
                localeList.add(locMapping.getLocale());
            }
            localeListArg = localeList.toArray(new String[0]);
        }
        if (((GetStatisticsOptions)this.getOpts()).getProj() == null) {
            log.error("Project slug is required but was not found. Aborting.");
            return;
        }
        if (((GetStatisticsOptions)this.getOpts()).getProj().isEmpty()) {
            log.error("Project slug is empty. Aborting.");
            return;
        }
        if (((GetStatisticsOptions)this.getOpts()).getProjectVersion() == null) {
            log.error("Version slug is required but was not found. Aborting.");
            return;
        }
        if (((GetStatisticsOptions)this.getOpts()).getProjectVersion().isEmpty()) {
            log.error("Version slug is empty. Aborting.");
            return;
        }
        ConsoleUtils.startProgressFeedback();
        ContainerTranslationStatistics containerStats = ((GetStatisticsOptions)this.getOpts()).getDocumentId() == null ? this.statsResource.getStatistics(((GetStatisticsOptions)this.getOpts()).getProj(), ((GetStatisticsOptions)this.getOpts()).getProjectVersion(), ((GetStatisticsOptions)this.getOpts()).getIncludeDetails(), ((GetStatisticsOptions)this.getOpts()).getIncludeWordLevelStats(), localeListArg) : this.statsResource.getStatistics(((GetStatisticsOptions)this.getOpts()).getProj(), ((GetStatisticsOptions)this.getOpts()).getProjectVersion(), ((GetStatisticsOptions)this.getOpts()).getDocumentId(), ((GetStatisticsOptions)this.getOpts()).getIncludeWordLevelStats(), localeListArg);
        ConsoleUtils.endProgressFeedback();
        if (((GetStatisticsOptions)this.getOpts()).getFormat() == null) {
            log.warn("Output format not specified; defaulting to Console output.");
        }
        if ("csv".equalsIgnoreCase(((GetStatisticsOptions)this.getOpts()).getFormat())) {
            statsOutput = new CsvStatisticsOutput();
        } else {
            if (!"console".equalsIgnoreCase(((GetStatisticsOptions)this.getOpts()).getFormat())) {
                log.warn("Invalid format type '{}', using console format instead.", (Object)((GetStatisticsOptions)this.getOpts()).getFormat());
            }
            statsOutput = new ConsoleStatisticsOutput();
        }
        statsOutput.write(containerStats);
    }
}

