/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import org.fedorahosted.openprops.Properties;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.push.PropertiesStrategy;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.TextFlow;
import org.zanata.util.PathUtil;

public class PropertiesPushStrategyTest {
    private File outDir = new File("target/test-output/readprops/");
    private Properties props;
    @Mock
    private PushOptions opts;

    @Before
    public void prepare() throws IOException {
        PathUtil.makeDirs((File)this.outDir);
        this.props = new Properties();
        this.props.setProperty("key", "value");
        this.props.setProperty("unicode", "\u30ec\u30b9");
    }

    @Before
    public void beforeMethod() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.opts.getSourceLang()).thenReturn((Object)"en");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void utf8() throws Exception {
        File f = new File(this.outDir, "utf8.properties");
        try (FileOutputStream fos = new FileOutputStream(f);){
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            this.props.store((Writer)w, null);
        }
        PropertiesStrategy strat = new PropertiesStrategy("UTF-8");
        strat.setPushOptions(this.opts);
        strat.init();
        Resource doc = strat.loadSrcDoc(this.outDir, "utf8");
        this.checkResults(doc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void latin1() throws Exception {
        File f = new File(this.outDir, "latin1.properties");
        try (FileOutputStream fos = new FileOutputStream(f);){
            this.props.store((OutputStream)fos, null);
        }
        PropertiesStrategy strat = new PropertiesStrategy();
        strat.setPushOptions(this.opts);
        strat.init();
        Resource doc = strat.loadSrcDoc(this.outDir, "latin1");
        this.checkResults(doc);
    }

    private void checkResults(Resource doc) {
        Assert.assertEquals((Object)((TextFlow)doc.getTextFlows().get(0)).getId(), (Object)"key");
        Assert.assertEquals((Object)((TextFlow)doc.getTextFlows().get(0)).getContents(), Arrays.asList("value"));
        Assert.assertEquals((Object)((TextFlow)doc.getTextFlows().get(1)).getId(), (Object)"unicode");
        Assert.assertEquals((Object)((TextFlow)doc.getTextFlows().get(1)).getContents(), Arrays.asList("\u30ec\u30b9"));
    }
}

