/*
 * Decompiled with CFR 0.152.
 */
package org.zanata.client.commands.push;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.zanata.client.commands.ConfigurableOptions;
import org.zanata.client.commands.DummyResponse;
import org.zanata.client.commands.OptionsUtil;
import org.zanata.client.commands.push.PushCommand;
import org.zanata.client.commands.push.PushOptions;
import org.zanata.client.commands.push.PushOptionsImpl;
import org.zanata.client.config.LocaleList;
import org.zanata.client.config.LocaleMapping;
import org.zanata.common.LocaleId;
import org.zanata.rest.StringSet;
import org.zanata.rest.client.IAsynchronousProcessResource;
import org.zanata.rest.client.ICopyTransResource;
import org.zanata.rest.client.ISourceDocResource;
import org.zanata.rest.client.ITranslatedDocResource;
import org.zanata.rest.client.ZanataProxyFactory;
import org.zanata.rest.dto.CopyTransStatus;
import org.zanata.rest.dto.ProcessStatus;
import org.zanata.rest.dto.resource.Resource;
import org.zanata.rest.dto.resource.ResourceMeta;
import org.zanata.rest.dto.resource.TextFlowTarget;
import org.zanata.rest.dto.resource.TranslationsResource;

public class PushCommandTest {
    @Mock
    ZanataProxyFactory mockRequestFactory;
    @Mock
    ISourceDocResource mockSourceDocResource;
    @Mock
    ITranslatedDocResource mockTranslationResources;
    @Mock
    ICopyTransResource mockCopyTransResource;
    @Mock
    IAsynchronousProcessResource mockAsynchronousProcessResource;

    public PushCommandTest() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
    }

    @Test
    public void pushSrc() throws Exception {
        this.push(false, false);
    }

    @Test
    public void pushSrcAndTarget() throws Exception {
        this.push(true, false);
    }

    @Test
    public void pushSrcAndTargetWithLocaleMapping() throws Exception {
        this.push(true, true);
    }

    @Test
    public void testSplitTranslationResource() throws Exception {
        int batchSize = 100;
        int listSize = 500;
        this.checkSplitResult(listSize, batchSize);
        batchSize = 50;
        listSize = 500;
        this.checkSplitResult(listSize, batchSize);
    }

    @Test
    public void testSplitTranslationResourceWithMod() throws Exception {
        int batchSize = 100;
        int listSize = 505;
        this.checkSplitResult(listSize, batchSize);
        batchSize = 100;
        listSize = 510;
        this.checkSplitResult(listSize, batchSize);
    }

    private void checkSplitResult(int listSize, int batchSize) throws Exception {
        int expectLastTftSize;
        PushCommand cmd = this.generatePushCommand(true, true);
        TranslationsResource transRes = new TranslationsResource();
        for (int i = 0; i < listSize; ++i) {
            transRes.getTextFlowTargets().add(new TextFlowTarget(String.valueOf(i)));
        }
        List list = cmd.splitIntoBatch(transRes, batchSize);
        int expectListSize = listSize / batchSize;
        if (listSize % batchSize != 0) {
            ++expectListSize;
        }
        if ((expectLastTftSize = listSize % batchSize) == 0) {
            expectLastTftSize = batchSize;
        }
        Assert.assertEquals((long)list.size(), (long)expectListSize);
        Assert.assertEquals((long)((TranslationsResource)list.get(0)).getTextFlowTargets().size(), (long)batchSize);
        Assert.assertEquals((long)((TranslationsResource)list.get(list.size() - 1)).getTextFlowTargets().size(), (long)expectLastTftSize);
    }

    private PushCommand generatePushCommand(boolean pushTrans, boolean mapLocale) throws Exception {
        PushOptionsImpl opts = new PushOptionsImpl();
        opts.setInteractiveMode(false);
        String projectSlug = "project";
        opts.setProj(projectSlug);
        String versionSlug = "1.0";
        opts.setProjectVersion(versionSlug);
        opts.setSrcDir(new File("src/test/resources/test1/pot"));
        if (pushTrans) {
            opts.setPushType("both");
        } else {
            opts.setPushType("source");
        }
        opts.setTransDir(new File("src/test/resources/test1"));
        opts.setProjectType("podir");
        opts.setCopyTrans(true);
        opts.setIncludes("**/*.pot");
        opts.setExcludes("");
        opts.setSourceLang("en-US");
        opts.setMergeType("auto");
        LocaleList locales = new LocaleList();
        if (mapLocale) {
            locales.add(new LocaleMapping("ja", "ja-JP"));
        } else {
            locales.add(new LocaleMapping("ja-JP"));
        }
        opts.setLocaleMapList(locales);
        OptionsUtil.applyConfigFiles((ConfigurableOptions)opts);
        Mockito.when((Object)this.mockRequestFactory.getCopyTransResource()).thenReturn((Object)this.mockCopyTransResource);
        Mockito.when((Object)this.mockRequestFactory.getAsynchronousProcessResource()).thenReturn((Object)this.mockAsynchronousProcessResource);
        return new PushCommand((PushOptions)opts, this.mockRequestFactory, this.mockSourceDocResource, this.mockTranslationResources, new URI("http://example.com/"));
    }

    private void push(boolean pushTrans, boolean mapLocale) throws Exception {
        ArrayList<ResourceMeta> resourceMetaList = new ArrayList<ResourceMeta>();
        resourceMetaList.add(new ResourceMeta("obsolete"));
        resourceMetaList.add(new ResourceMeta("RPM"));
        Mockito.when((Object)this.mockSourceDocResource.get(null)).thenReturn(new DummyResponse(Response.Status.OK, resourceMetaList));
        DummyResponse<Object> okResponse = new DummyResponse<Object>(Response.Status.OK, null);
        Mockito.when((Object)this.mockSourceDocResource.deleteResource("obsolete")).thenReturn(okResponse);
        StringSet extensionSet = new StringSet("gettext;comment");
        ProcessStatus mockStatus = new ProcessStatus();
        mockStatus.setStatusCode(ProcessStatus.ProcessStatusCode.Finished);
        mockStatus.setMessages(new ArrayList());
        Mockito.when((Object)this.mockAsynchronousProcessResource.startSourceDocCreationOrUpdate((String)Matchers.eq((Object)"RPM"), Matchers.anyString(), Matchers.anyString(), (Resource)Matchers.notNull(), (Set)Matchers.eq((Object)extensionSet), Matchers.eq((boolean)false))).thenReturn((Object)mockStatus);
        Mockito.when((Object)this.mockAsynchronousProcessResource.startSourceDocCreationOrUpdate((String)Matchers.eq((Object)"sub,RPM"), Matchers.anyString(), Matchers.anyString(), (Resource)Matchers.notNull(), (Set)Matchers.eq((Object)extensionSet), Matchers.eq((boolean)false))).thenReturn((Object)mockStatus);
        Mockito.when((Object)this.mockAsynchronousProcessResource.getProcessStatus(Matchers.anyString())).thenReturn((Object)mockStatus);
        CopyTransStatus mockCopyTransStatus = new CopyTransStatus();
        mockCopyTransStatus.setInProgress(false);
        mockCopyTransStatus.setPercentageComplete(100);
        Mockito.when((Object)this.mockCopyTransResource.getCopyTransStatus(Matchers.anyString(), Matchers.anyString(), Matchers.anyString())).thenReturn((Object)mockCopyTransStatus);
        if (pushTrans) {
            LocaleId expectedLocale = mapLocale ? new LocaleId("ja") : new LocaleId("ja-JP");
            Mockito.when((Object)this.mockAsynchronousProcessResource.startTranslatedDocCreationOrUpdate((String)Matchers.eq((Object)"RPM"), Matchers.anyString(), Matchers.anyString(), (LocaleId)Matchers.eq((Object)expectedLocale), (TranslationsResource)Matchers.notNull(), (Set)Matchers.eq((Object)extensionSet), (String)Matchers.eq((Object)"auto"))).thenReturn((Object)mockStatus);
        }
        PushCommand cmd = this.generatePushCommand(pushTrans, mapLocale);
        cmd.runWithActions();
    }
}

